MODULE FUP_0_16_D
!   
!  U PROGRAMU KOJI UKLJUCUJE (MODULE FUP_0_16) POTREBNOJE DA PRVA IZVRSNA NAREDBA BUDE
! ******************  CALL  RACUN  ******************
!   
!
!  MODUL DONOSI U GLAVNI PROGRAM POLJA S VRIJEDNOSTIMA DERIVACIJA FUNKCIJE
!  FUPn(x),  NA RAZMAKU 2**(-M), M = 16,  n = 0-0,...,16-16
!         !!!  N A J B R Z A   V A R I J A N T A  !!!
!  Derivacije za pojedinu funkciju Fupn(x) se izracunavaju od nultog do n-tog reda




   PUBLIC RACUN, FUPN  !

   PRIVATE UPTURBOX, FUP00, FUP01, FUP02, FUP03, FUP04, FUP05, FUP06, FUP07,  &
                      FUP08, FUP09, FUP10, FUP11, FUP12, FUP13, FUP14, FUP15, FUP16, &
                      NFUP, VERTEX, XPOINT, DELTAX, KOD, K,M,N,KK,J00,J01,J02,J03,  &
                      WORK, D,C00,DX,DX0 


   CONTAINS

   SUBROUTINE RACUN
    
!
!  PODPROGRAM VRACA POLJA S VRIJEDNOSTIMA DERIVACIJA FUNKCIJE FUPn(x) NA RAZMAKU 2**(-M), M = 16
!  n = 0-0,...,16-16         !!!  N A J B R Z A   V A R I J A N T A  !!!
!
   INTEGER(4) :: K,M,N,KK,J00,J01,J02,J03

   real(kind=8)  D,C00,DX,DX0
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16

   DIMENSION D(32)
   real(8), ALLOCATABLE :: WORK(:,:)
   !(-2*65536:65536,0:16)

!   PARAMETER ( M = 16 )
!   PARAMETER ( DX = 1.0D0 )  ! DEFAULT, INACE SE MORA ZADATI KONKRETNA VRIJEDNOST ' DX '
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)

!   CALL CPU_TIME(T0)
!   WRITE(*,*) T0

   M  = 16
   DX = 1.D0   ! DEFAULT, INACE SE MORA ZADATI KONKRETNA VRIJEDNOST ' DX '


!!! Calculate coefficient Delta (+-1)

   D(1) = 1.D0
   DO K = 1,16
   D(2*K-1) = D(K)
   D(2*K) = -D(K)
   END DO

!!! Fill array of U (value of UP function - 2E16)

          CALL UPTURBOX(M)

!IZRACUNAVANJE SVIH DERIVACIJA FUNKCIJE up(x)


      ALLOCATE (WORK(-2*65536:65536,0:16))
         K = -2**M
      DO K = -2**M,2**M
      WORK(K,0) = FUP_00(K, 0)
     
      END DO
         N = 1
      DO N = 1,M  !!!+1  !!!!
              K = 0
           DO K = 0,2**(M-N+1) 
           WORK(-2**M+K,N) = 2.0D0**((N*(N+1))/2)*FUP_00(-2**M+K*2**N,0)
           END DO
      END DO
         N = 2
      DO N = 2,M   !!!+1   !!!
           DO K = 0,2**(M-N+1)
                           KK = 2
                        DO KK = 2,N
     WORK(-2**M+2**(M-N+1)*(KK-1)+K, N) = D(KK)*WORK(-2**M+K,N)
                         END DO
           END DO
      END DO


!    Izracunavanje vrijednosti nulte i prvih (N+1) derivacija funkcije Fupn(x)
           N = 0
        DO N = 0,M
              J00 = 2**M
              J01 = ((N+2)*2**(M-N))/2
  J02 = 0
  J03 = 2**(M-N)
 C00 = 2.0D0**((N*(N+1))/2) 

  DX0 = 2.0D0**(-N)
                      
                           IF(N == 1) THEN
                    KK = 0
                 DO KK = 0,N+1  !!!
                     K = 0
                 DO  K = 0,J01            
 FUP_01(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-WORK(-J00-J03+K,KK))
     FUP_01( J01-K,KK) = (-1.0D0)**KK*FUP_01(-J01+K,KK)
                 END DO
                 END DO
          
                      ELSE IF(N == 2) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01           
FUP_02(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-2.0D0*WORK(-J00-J03+K,KK))
FUP_02( J01-K,KK) = (-1.0D0)**KK*FUP_02(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 3) THEN
 			
                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01          
FUP_03(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-3.0D0*WORK(-J00-J03+K,KK)+ &
              4.0D0*WORK(-J00-2*J03+K,KK))
 FUP_03( J01-K,KK) = (-1.0D0)**KK*FUP_03(-J01+K,KK)
                 END DO
                 END DO
 
                      ELSE IF(N == 4) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
     DO  K = 0,J01           
 FUP_04(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-4.0D0*WORK(-J00-J03+K,KK)+ &
                  7.0D0*WORK(-J00-2*J03+K,KK))
     FUP_04( J01-K,KK) = (-1.0D0)**KK*FUP_04(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 5) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
     DO  K = 0,J01   
 FUP_05(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-5.0D0*WORK(-J00-J03+K,KK)+ &
                   11.0D0*WORK(-J00-2*J03+K,KK)-15.0D0*WORK(-J00-3*J03+K,KK))
     FUP_05( J01-K,KK) = (-1.0D0)**KK*FUP_05(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 6) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
     DO  K = 0,J01              
 FUP_06(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-6.0D0*WORK(-J00-J03+K,KK)+ &
                 16.0D0*WORK(-J00-2*J03+K,KK)-26.0D0*WORK(-J00-3*J03+K,KK))
     FUP_06( J01-K,KK) = (-1.0D0)**KK*FUP_06(-J01+K,KK)
                 END DO
                 END DO
 
                     ELSE IF(N == 7) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
    DO  K = 0,J01              
 FUP_07(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-7.0D0*WORK(-J00-J03+K,KK)+ &
  22.0D0*WORK(-J00-2*J03+K,KK)-42.0D0*WORK(-J00-3*J03+K,KK)+ &
 58.0D0*WORK(-J00-4*J03+K,KK))
     FUP_07( J01-K,KK) = (-1.0D0)**KK*FUP_07(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 8) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01             
FUP_08(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-8.0D0*WORK(-J00-J03+K,KK)+ &
 29.0D0*WORK(-J00-2*J03+K,KK)-64.0D0*WORK(-J00-3*J03+K,KK)+ &
 100.0D0*WORK(-J00-4*J03+K,KK))
     FUP_08( J01-K,KK) = (-1.0D0)**KK*FUP_08(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 9) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
 DO  K = 0,J01              
FUP_09(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-9.0D0*WORK(-J00-J03+K,KK)+ &
 37.0D0*WORK(-J00-2*J03+K,KK)-93.0D0*WORK(-J00-3*J03+K,KK)+ &
164.0D0*WORK(-J00-4*J03+K,KK)-228.0D0*WORK(-J00-5*J03+K,KK))
     FUP_09( J01-K,KK) = (-1.0D0)**KK*FUP_09(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 10) THEN
                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
 DO  K = 0,J01           
FUP_10(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-10.0D0*WORK(-J00-J03+K,KK)+ &
           46.0D0*WORK(-J00-2*J03+K,KK)-130.0D0*WORK(-J00-3*J03+K,KK)+ &
  257.0D0*WORK(-J00-4*J03+K,KK)-392.0D0*WORK(-J00-5*J03+K,KK))
     FUP_10( J01-K,KK) = (-1.0D0)**KK*FUP_10(-J01+K,KK)
                 END DO
                 END DO

 ELSE IF(N == 11) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
   DO  K = 0,J01               
FUP_11(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-11.0D0*WORK(-J00-J03+K,KK)+ &
 56.0D0*WORK(-J00-2*J03+K,KK)-176.0D0*WORK(-J00-3*J03+K,KK)+ &
  387.0D0*WORK(-J00-4*J03+K,KK)-649.0D0*WORK(-J00-5*J03+K,KK)+ &
 904.0D0*WORK(-J00-6*J03+K,KK))
     FUP_11( J01-K,KK) = (-1.0D0)**KK*FUP_11(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 12) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01              
 FUP_12(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-12.0D0*WORK(-J00-J03+K,KK)+ &
  67.0D0*WORK(-J00-2*J03+K,KK)-232.0D0*WORK(-J00-3*J03+K,KK)+ &
 563.0D0*WORK(-J00-4*J03+K,KK)-1036.0D0*WORK(-J00-5*J03+K,KK)+ &
   1553.0D0*WORK(-J00-6*J03+K,KK))
     FUP_12( J01-K,KK) = (-1.0D0)**KK*FUP_12(-J01+K,KK)

                 END DO
                 END DO

                      ELSE IF(N == 13) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01              
 FUP_13(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-13.0D0*WORK(-J00-J03+K,KK)+ &
                  79.0D0*WORK(-J00-2*J03+K,KK)-299.0D0*WORK(-J00-3*J03+K,KK)+ &
  795.0D0*WORK(-J00-4*J03+K,KK)-1599.0D0*WORK(-J00-5*J03+K,KK)+ &
   2589.0D0*WORK(-J00-6*J03+K,KK)-3601.0D0*WORK(-J00-7*J03+K,KK))
     FUP_13( J01-K,KK) = (-1.0D0)**KK*FUP_13(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 14) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
  DO  K = 0,J01              
FUP_14(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-14.0D0*WORK(-J00-J03+K,KK)+ &
92.0D0*WORK(-J00-2*J03+K,KK)-378.0D0*WORK(-J00-3*J03+K,KK)+ &
1094.0D0*WORK(-J00-4*J03+K,KK)-2394.0D0*WORK(-J00-5*J03+K,KK)+ &
4188.0D0*WORK(-J00-6*J03+K,KK)-6190.0D0*WORK(-J00-7*J03+K,KK))
     FUP_14( J01-K,KK) = (-1.0D0)**KK*FUP_14(-J01+K,KK)

                 END DO
                 END DO

                      ELSE IF(N == 15) THEN

                    KK = 0
                 DO KK = 0,N+1 !!!
                     K = 0
 DO  K = 0,J01               
FUP_15(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-15.0D0*WORK(-J00-J03+K,KK)+ &
106.0D0*WORK(-J00-2*J03+K,KK)-470.0D0*WORK(-J00-3*J03+K,KK)+ &
1472.0D0*WORK(-J00-4*J03+K,KK)-3488.0D0*WORK(-J00-5*J03+K,KK)+ &
6582.0D0*WORK(-J00-6*J03+K,KK)-10378.0D0*WORK(-J00-7*J03+K,KK)+ &
14384.0D0*WORK(-J00-8*J03+K,KK))
     FUP_15( J01-K,KK) = (-1.0D0)**KK*FUP_15(-J01+K,KK)
                 END DO
                 END DO

                      ELSE IF(N == 16) THEN

                    KK = 0
                 DO KK = 0,N !!!
                     K = 0
DO  K = 0,J01             
FUP_16(-J01+K,KK) = (DX0**KK)*C00*(WORK(-J00+K,KK)-16.0D0*WORK(-J00-J03+K,KK)+ &
121.0D0*WORK(-J00-2*J03+K,KK)-576.0D0*WORK(-J00-3*J03+K,KK)+ &
1942.0D0*WORK(-J00-4*J03+K,KK)-4960.0D0*WORK(-J00-5*J03+K,KK)+ &
10070.0D0*WORK(-J00-6*J03+K,KK)-16960.0D0*WORK(-J00-7*J03+K,KK)+ &
24762.0D0*WORK(-J00-8*J03+K,KK))
     FUP_16( J01-K,KK) = (-1.0D0)**KK*FUP_16(-J01+K,KK)
                 END DO
                 END DO

                      END IF
    
      END DO
!
      DEALLOCATE (WORK)

!
      END SUBROUTINE RACUN
   
!!!  Calculate value of UP function in the arbitrary points

      SUBROUTINE UPTURBOX(M)
  
       
real(8) UN,FAK,UNN,UN0,SUMAK,FUP_00,ZERO
COMMON FUP_00(0:131072, 0:1)
      DIMENSION UN(0:20),FAK(0:20),UNN(0:20),UN0(0:20)
      INTEGER(4) M,N,L,I,K
      
DATA UN0/1.0D0, 1.0D0, 5.0D0, 1.0D0, 143.0D0, 19.0D0, 1153.0D0,&
      583.0D0,1616353.0D0,132809.0D0, 134926369.0D0, 46840699.0D0,&
      67545496213157.0D0,4068990560161.0D0,411124285571171.0D0,&
      1204567303451311.0D0,73419800947733963069.0D0,&
      4146897304424408411.0D0,86773346866163284480799923.0D0,&
      18814360006695807527868793.0D0,&
      539741515875650532056045666422369.0D0/
!!!
      DATA UNN/1.0D0, 2.0D0, 72.0D0, 288.0D0, 2073600.0D0,&
      33177600.0D0, 561842749440.0D0, 179789679820800.0D0,&
      704200217922109440000.0D0, 180275255788060016640000.0D0,&
      1246394851358539387238350848000.0D0,&
      6381541638955721662660356341760000.0D0,&
      292214732887898713986916575925267070976000000.0D0,&
      1196911545908833132490410294989893922717696000000.0D0,&
      17524030168305511965050671651660013242599473361715200000.0D0,&
     15791254065263462941946461238743871133171237435708801024000000.0D0,&
626048168100066478643636623385103067560649311175417997219699097600000000.0D0,&
48488455061807039788823800613832680933046479303954410932297509162188800000000.0D0,  &
2924907327984663493179931480281060829152039746976389598046631610524565901849531514880000000.0D0,  &
3833734532936058133780799789833992049986161537156893373951680984546759018872217947183513600000000.0D0,  &
1391026453346497029228605426710671587340398341822365591105864134203768975246595308345805415518935449600000000000.0D0/
!!!
      DATA FAK/1.0D0,1.0D0,2.0D0,6.0D0,24.0D0,120.0D0,720.0D0,5040.0D0, &
          40320.0D0,362880.0D0,3628800.0D0,39916800.0D0,479001600.0D0,  &
      6227020800.0D0,87178291200.0D0,1307674368000.0D0,&
      20922789888000.0D0,355687428096000.0D0,6402373705728000.0D0,&
      121645100408832000.0D0,2432902008176640000.0D0/
!!!
      DATA ZERO/0.0D0/

           I = 0
        DO I = 0,M
                    UN(I) = UN0(I)/UNN(I)
FAK(I)= 2.0D0**((I*(I+1))/2)/FAK(I)
        END DO 

                  FUP_00  = 0.0D0
 FUP_00(1,0) = UN(M)
FUP_00(2,0) = UN(M-1)

 N = 1
 DO N = 1,M 
K = 2**N                      
 DO K = 2**N,2**(N+1)
                          SUMAK = ZERO
                                         L = 0
                                      DO L = 0,M-N 
           SUMAK = SUMAK + FAK(L)*UN(M-N-L)*(2.0D0**(-M)*(K-2**N))**L
                                      END DO
                                      FUP_00(K, 0) = SUMAK - FUP_00(K-2**N, 0)
                          END DO
                  END DO
		  
		  
		  
DO K = 0, 65536
                         FUP_00(K,1) = 2.0*FUP_00(2*K,0)
                         FUP_00(K+65536,1) = -FUP_00(K,1)
END DO 
 
     END SUBROUTINE UPTURBOX



    real(8) FUNCTION FUPN(NFUP, VERTEX, XPOINT, DELTAX, KOD)
	 
                      
    INTEGER(4) ::  NFUP,KOD
real(8)    ::  VERTEX, XPOINT, DELTAX

    SELECT CASE (NFUP)

    CASE ( 0)
    FUPN = FUP00(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 1)
    FUPN = FUP01(VERTEX, XPOINT, DELTAX, KOD)
CASE ( 2)
FUPN = FUP02(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 3)    
FUPN = FUP03(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 4)    
FUPN = FUP04(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 5)    
FUPN = FUP05(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 6)    
FUPN = FUP06(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 7)    
FUPN = FUP07(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 8)    
FUPN = FUP08(VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 9)    
FUPN = FUP09(VERTEX, XPOINT, DELTAX, KOD)
    CASE (10)    
FUPN = FUP10(VERTEX, XPOINT, DELTAX, KOD)
    CASE (11)    
FUPN = FUP11(VERTEX, XPOINT, DELTAX, KOD)
    CASE (12)    
FUPN = FUP12(VERTEX, XPOINT, DELTAX, KOD)
    CASE (13)    
FUPN = FUP13(VERTEX, XPOINT, DELTAX, KOD)
    CASE (14)    
FUPN = FUP14(VERTEX, XPOINT, DELTAX, KOD)
    CASE (15)    
FUPN = FUP15(VERTEX, XPOINT, DELTAX, KOD)
    CASE (16)    
FUPN = FUP16(VERTEX, XPOINT, DELTAX, KOD)
    END SELECT

    END FUNCTION FUPN



    real(8) FUNCTION FUP00(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, INDEX, DVANF, KOD
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD=0, 1  -  indeks reda trazene derivacije 
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 0
   DVANF = 65536     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP00 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP00 = FUP_00(INDEX, KOD)
   END IF
   END FUNCTION FUP00




    real(8) FUNCTION FUP01(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1 
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 1
   DVANF = 32768     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP01 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP01 = FUP_01(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP01




    real(8) FUNCTION FUP02(VERTEX, XPOINT, DELTAX, KOD)
	 
INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2 
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 2
   DVANF = 16384     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY) .GE.  float((DVANF*(NFUP+2)/2))) THEN
              FUP02 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP02 = FUP_02(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP02




    real(8) FUNCTION FUP03(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 3
   DVANF = 8192     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP03 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP03 = FUP_03(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP03





    real(8) FUNCTION FUP04(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3,4
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 4
   DVANF = 4096     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP04 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP04 = FUP_04(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP04


    real(8) FUNCTION FUP05(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3,4,5
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 5
   DVANF = 2048     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP05 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP05 = FUP_05(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP05


    real(8) FUNCTION FUP06(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3,4,5,6
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 6
   DVANF = 1024     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP06 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP06 = FUP_06(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP06


    real(8) FUNCTION FUP07(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2,3,4
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 7
   DVANF = 512     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP07 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP07 = FUP_07(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP07


    real(8) FUNCTION FUP08(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,7,8
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 8
   DVANF = 256     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP08 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP08 = FUP_08(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP08


    real(8) FUNCTION FUP09(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,9
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 9
   DVANF = 128     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP09 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP09 = FUP_09(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP09


    real(8) FUNCTION FUP10(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,10
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 10
   DVANF = 64     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP10 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP10 = FUP_10(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP10


    real(8) FUNCTION FUP11(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,11
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 11
   DVANF = 32     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP11 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP11 = FUP_11(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP11

    real(8) FUNCTION FUP12(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1, ... ,12
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 12
   DVANF = 16     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP12 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP12 = FUP_12(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP12


    real(8) FUNCTION FUP13(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1, ... ,13
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 13
   DVANF =  8     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP13 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP13 = FUP_13(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP13


    real(8) FUNCTION FUP14(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,14
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 14
   DVANF =  4     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP14 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP14 = FUP_14(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP14


    real(8) FUNCTION FUP15(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,15
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 15
   DVANF =  2   !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP15 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP15 = FUP_15(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP15


    real(8) FUNCTION FUP16(VERTEX, XPOINT, DELTAX, KOD)
	 
    INTEGER(4) NFUP, KOD, INDEX, DVANF
real(8) VERTEX, XPOINT, DELTAX,  DUMMY

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!   Funkcijski podprogram za izracunavanje vrijednosti funkcije i prvih n derivacija        
!   za bazne funkcije Fupn(x) reda n = 0,1,2, ... ,16
!     
!           NFUP   -  red "n" odabrane bazne funkcije Fupn(x)
!           VERTEX -  koordinata tjemena odabrane bazne funkcije Fupn(x)
!           XPOINT -  koordinata tocke u kojoj se izracunava vrijednost derivacije reda <=n
!           DELTAX -  duljina karakteristicnog odsjecka
!           KOD    -  indeks reda trazene derivacije 0,1,2, ... ,16
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real(8)  FUP_00, FUP_01, FUP_02, FUP_03, FUP_04, FUP_05, FUP_06, FUP_07, FUP_08, &
            FUP_09, FUP_10, FUP_11, FUP_12, FUP_13, FUP_14, FUP_15, FUP_16
   COMMON   FUP_00(-65536:65536,0: 1), &
            FUP_01(-49152:49152,0: 2), FUP_02(-32768:32768,0: 3), FUP_03(-20480:20480,0: 4), &
            FUP_04(-12288:12288,0: 5), FUP_05( -7168: 7168,0: 6), FUP_06( -4096: 4096,0: 7), &
            FUP_07( -2304: 2304,0: 8), FUP_08( -1280: 1280,0: 9), FUP_09(  -704:  704,0:10), &
            FUP_10(  -384:  384,0:11), FUP_11(  -208:  208,0:12), FUP_12(  -112:  112,0:13), &
            FUP_13(   -60:   60,0:14), FUP_14(   -32:   32,0:15), FUP_15(   -17:   17,0:16), &
            FUP_16(    -9:    9,0:17)
   NFUP  = 16
   DVANF =  1     !  2**(16-NFUP)
   DUMMY = (XPOINT-VERTEX)/DELTAX* float(DVANF)

   IF(abs(DUMMY).GE. float((DVANF*(NFUP+2)/2))) THEN
              FUP16 = 0.0D0
   ELSE
       INDEX = Nint(DUMMY)
       FUP16 = FUP_16(INDEX,KOD)/DELTAX**KOD
   END IF
   END FUNCTION FUP16



END MODULE FUP_0_16_D    

MODULE SPLINE_1_4_D

    PUBLIC SPLINEN
    
    CONTAINS
    

    real(8) FUNCTION SPLINEN(NSPLINE, VERTEX, XPOINT, DELTAX, KOD)
	 
                      
    INTEGER(4) ::  NSPLINE,KOD
real(8)    ::  VERTEX, XPOINT, DELTAX

    SELECT CASE (NSPLINE)

    CASE ( 1)
SPLINEN = AlgSplineB01(NSPLINE, VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 2)
SPLINEN = AlgSplineB02(NSPLINE, VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 3)    
SPLINEN = AlgSplineB03(NSPLINE, VERTEX, XPOINT, DELTAX, KOD)
    CASE ( 4)    
SPLINEN = AlgSplineB04(NSPLINE, VERTEX, XPOINT, DELTAX, KOD)
    
    END SELECT

    END FUNCTION SPLINEN
    
    real(8) FUNCTiON AlgSplineB01 (order, vertex, xpoint, deltax, kod)
    ! ************************************************* ALGEBARSki SPLiNE PRVOG STUPNjA******************************************************
    ! Funkcijski podprogram za izraeunavanje vrijednosti nulte i prve dvije derivacije funkcije AlgSplineB02 ( order, vertex, deltax, xpoint, kod )
    !   order  - red spline-a
    !	deltax - kARAkTERiSTiCNi OdsjECAk
    !	vertex - X-kOORDiNATA TjEMENA
    !	xpoint - ZADANA kOORDDiNATA TOEkE
    !	kod - RED DERiVAcijE (0,1)	
    ! ============================================================================================================================
iMPLiciT NONE
iNTEGER (4)order, kod
real(8)vertex, deltax, xpoint, xlocal,RESULT
	

xlocal=(xpoint-vertex)/deltax! UZiMA xpoint i PREBACUjE U xlocal 
	
RESULT = 0.0D0

iF (kod == 0) THEN
	
    !        *********** NULTA DERiVAcijA **********	

iF (xlocal>=  -1.0D0 .AND. xlocal   <=   0.0D0)&
RESULT = ABS(xlocal+1.0D0)
iF (xlocal>=   0.0D0 .AND. xlocal   <=  1.0D0)&
RESULT = ABS(-xlocal-1.0D0+2.0D0)
			
ELSE  iF (kod == 1) THEN

    !        *********** PRVA DERiVAcijA **********

iF (xlocal>=  -1.0D0 .AND. xlocal   <=   0.0D0)&
RESULT = 1.0D0
iF (xlocal>=   0.0D0 .AND. xlocal   <=  1.0D0)&
RESULT = -1.0D0

ELSE 

		    !WRiTE (*,*)   'RED  DERiVAcijE  iZVAN  DOPUSTENOG  0 - 1'


        END iF

            !Derivative value
            RESULT=RESULT/deltax**kod   !***!
AlgSplineB01 = RESULT! VRACA 1 BROj, ODNOSNO VRACA VRijEDNOST ALGSPLiNEB03 U TOCki xpoint


    END FUNCTiON AlgSplineB01
            
    real(8) FUNCTiON AlgSplineB02 (order, vertex, xpoint, deltax, kod)
    ! ************************************************* ALGEBARSki SPLiNE DRUGOG STUPNjA******************************************************
    ! Funkcijski podprogram za izraeunavanje vrijednosti nulte i prve dvije derivacije funkcije AlgSplineB02 ( order, vertex, deltax, xpoint, kod )
    !   order  - red spline-a
    !	deltax - kARAkTERiSTiCNi OdsjECAk
    !	vertex - X-kOORDiNATA TjEMENA
    !	xpoint - ZADANA kOORDDiNATA TOEkE
    !	kod - RED DERiVAcijE (0,1,2)	
    ! ============================================================================================================================
iMPLiciT NONE
iNTEGER (4)order, kod
real(8)vertex, deltax, xpoint, xlocal, RESULT
	

xlocal=(xpoint-vertex)/deltax! UZiMA xpoint i PREBACUjE U xlocal 
	
RESULT = 0.0D0

iF (kod == 0) THEN
	
    !        *********** NULTA DERiVAcijA **********	

iF(xlocal>=-1.5D0 .AND. xlocal   <=  -0.5D0)&
RESULT=ABS((xlocal+1.5D0)**2/2.0D0)
iF (xlocal>=  -0.5D0 .AND. xlocal   <=  0.5D0)&
RESULT=ABS(-(xlocal+1.5D0)**2+3.0D0*(xlocal+1.5D0)-3.0D0/2.0D0)
iF (xlocal>=  0.5D0 .AND. xlocal   <=  1.5D0)&
RESULT=ABS(1.0D0/2.0D0*(xlocal+1.5D0)**2-3.0D0*(xlocal+1.5D0)+9.0D0/2.0D0)
			
ELSE  iF (kod == 1) THEN

    !        *********** PRVA DERiVAcijA **********

iF (xlocal>=  -1.5D0 .AND. xlocal   <=  -0.5D0)&
RESULT = (xlocal+1.5D0)
iF (xlocal>=  -0.5D0 .AND. xlocal   <=  0.5D0)&
RESULT = -2.0D0*xlocal
iF (xlocal>=  0.5D0 .AND. xlocal   <=  1.5D0)&
RESULT = xlocal-1.5D0
	
ELSE  iF (kod == 2) THEN

    !        *********** DRUGA DERiVAcijA **********

iF (xlocal>=  -1.5D0 .AND. xlocal   <=  -0.5D0)&
RESULT = 1.0D0
iF (xlocal>=  -0.5D0 .AND. xlocal   <=  0.5D0)&
RESULT =-2.0D0
iF (xlocal>=  0.5D0 .AND. xlocal   <=  1.5D0)&
RESULT = 1.0D0

ELSE 

WRiTE (*,*)   'RED  DERiVAcijE  iZVAN  DOPUSTENOG  0 - 2'


        END iF

            !Derivative value
            RESULT=RESULT/deltax**kod   !***!
AlgSplineB02 = RESULT! VRACA 1 BROj, ODNOSNO VRACA VRijEDNOST ALGSPLiNEB03 U TOCki xpoint


    END FUNCTiON AlgSplineB02
        
    real(8) FUNCTiON AlgSplineB03 (order, vertex, xpoint, deltax, kod)
    ! ************************************************* ALGEBARSki SPLiNE TRECEG STUPNjA******************************************************
    ! Funkcijski podprogram za izraeunavanje vrijednosti nulte i prve TRi derivacije funkcije AlgSplineB03 ( order, vertex, deltax, xpoint, kod )
    !   order  - red spline-a
    !	deltax - kARAkTERiSTiCNi OdsjECAk
    !	vertex - X-kOORDiNATA TjEMENA
    !	xpoint - ZADANA kOORDDiNATA TOEkE
    !	kod - RED DERiVAcijE (0,1,2,3)	
    ! ============================================================================================================================
iMPLiciT NONE
iNTEGER (4)order, kod
real(8)vertex, deltax, xpoint, xlocal, RESULT
	

xlocal = (xpoint-vertex)/deltax! UZiMA xpoint i PREBACUjE U xlocal 
	
RESULT = 0.0D0

iF (kod == 0) THEN
	
    !        *********** NULTA DERiVAcijA **********	

iF (xlocal>=  -2.0D0 .AND. xlocal   <=  -1.0D0)&
 RESULT = ABS((xlocal+2.0D0)**3/6.0D0)
 iF (xlocal>=  -1.0D0 .AND. xlocal   <=  0.0D0)&
 RESULT = ABS((-3.0D0*xlocal**3 - 6.0D0*xlocal**2+4.0D0)/6.0D0)
iF (xlocal>=  0.0D0 .AND. xlocal   <=  1.0D0)&
 RESULT = ABS((3.0D0*xlocal**3-6.0D0*xlocal**2+4.0D0)/6.0D0)
iF (xlocal>=  1.0D0 .AND. xlocal   <=  2.0D0)&
RESULT = ABS(-(xlocal-2.0D0)**3/6.0D0)
			
ELSE  iF (kod == 1) THEN

    !        *********** PRVA DERiVAcijA **********

iF (xlocal>=  -2.0D0 .AND. xlocal   <=  -1.0D0)&
    RESULT = (xlocal+2.0D0)**2/2.0D0
iF (xlocal>= -1.0D0 .AND. xlocal   <=  0.0D0)&
    RESULT = -xlocal*(3.0D0*xlocal+4.0D0)/2.0D0
iF (xlocal>=  0.0D0 .AND. xlocal   <=  1.0D0)&
    RESULT =xlocal*(3.0D0*xlocal-4.0D0)/2.0D0
iF (xlocal>=  1.0D0 .AND. xlocal   <=  2.0D0)&
    RESULT =  -(xlocal-2.0D0)**2/2.0D0
	
 ELSE  iF (kod == 2) THEN

    !        *********** DRUGA DERiVAcijA **********

 iF (xlocal>=  -2.0D0 .AND. xlocal   <=  -1.0D0)&
    RESULT = xlocal+2.0D0
    iF (xlocal>= -1.0D0 .AND. xlocal   <=  0.0D0)&
    RESULT = -3.0D0*xlocal - 2.0D0
    iF (xlocal>=  0.0D0 .AND. xlocal   <=  1.0D0)&
    RESULT =3.0D0*xlocal - 2.0D0
    iF (xlocal>=  1.0D0 .AND. xlocal   <=  2.0D0)&
    RESULT =  -(xlocal-2.0D0)


ELSE  iF (kod == 3) THEN

    !        *********** TRECA DERiVAcijA **********
				
   iF (xlocal>=  -2.0D0 .AND. xlocal   <=  -1.0D0)&
   RESULT = 1.0D0
   iF (xlocal>= -1.0D0 .AND. xlocal   <=  0.0D0)&
   RESULT = -3.0D0
   iF (xlocal>=  0.0D0 .AND. xlocal   <=  1.0D0)&
   RESULT = 3.0D0
   iF (xlocal>=  1.0D0 .AND. xlocal   <=  2.0D0)&
   RESULT =  -1.0D0

 ELSE 

WRiTE (*,*)   'RED  DERiVAcijE  iZVAN  DOPUSTENOG  0 - 3'


        END iF

            !Derivative value
            RESULT=RESULT/deltax**kod   !***!
 AlgSplineB03 = RESULT! VRACA 1 BROj, ODNOSNO VRACA VRijEDNOST ALGSPLiNEB03 U TOCki xpoint


    END FUNCTiON AlgSplineB03
        
    real(8) FUNCTiON AlgSplineB04 (order, vertex, xpoint, deltax, kod)
    ! ************************************************* ALGEBARSki SPLiNE TRECEG STUPNjA******************************************************
    ! Funkcijski podprogram za izraeunavanje vrijednosti nulte i prve TRi derivacije funkcije AlgSplineB03 ( order, vertex, deltax, xpoint, kod )
    !   order  - red spline-a
    !	deltax - kARAkTERiSTiCNi OdsjECAk
    !	vertex - X-kOORDiNATA TjEMENA
    !	xpoint - ZADANA kOORDDiNATA TOEkE
    !	kod - RED DERiVAcijE (0,1,2,3,4)	
    ! ============================================================================================================================
iMPLiciT NONE
   iNTEGER (4)order, kod
   real(8)vertex, deltax, xpoint, xlocal, RESULT
	

   xlocal = (xpoint-vertex)/deltax! UZiMA xpoint i PREBACUjE U xlocal 
	
   RESULT = 0.0D0

   iF (kod == 0) THEN
	
    !        *********** NULTA DERiVAcijA **********	

    iF (xlocal>=  -2.5D0 .AND. xlocal    <=  -1.5D0)&
    RESULT = ABS((xlocal+2.5D0)**4/24.0D0)
    iF (xlocal>=  -1.5D0 .AND. xlocal    <=  -0.5D0)&
    RESULT = ABS((-4.D0*(xlocal+2.5D0)**4+20.D0*(xlocal+2.5D0)**3-30.D0*(xlocal+2.5D0)**2+20.D0*(xlocal+2.5D0)-5.D0)/24.0D0)
    iF (xlocal>=  -0.5D0 .AND. xlocal    <=  0.5D0)&
    RESULT = ABS((6.D0*(xlocal+2.5D0)**4-60.D0*(xlocal+2.5D0)**3+210.D0*(xlocal+2.5D0)**2-300.D0*(xlocal+2.5D0)+155.D0)/24.0D0)
    iF (xlocal>=  0.5D0 .AND. xlocal    <=  1.5D0)&
    RESULT = ABS((-4.D0*(xlocal+2.5D0)**4+60.D0*(xlocal+2.5D0)**3-330.D0*(xlocal+2.5D0)**2+780.D0*(xlocal+2.5D0)-655.D0)/24.0D0)
    iF (xlocal>=  1.5D0 .AND. xlocal    <=  2.5D0)&
    RESULT = ABS((1.D0*(xlocal+2.5D0)**4-20.D0*(xlocal+2.5D0)**3+150.D0*(xlocal+2.5D0)**2-500.D0*(xlocal+2.5D0)+625.D0)/24.0D0)
            
ELSE  iF (kod == 1) THEN

    !        *********** PRVA DERiVAcijA **********

iF (xlocal>=  -2.5D0 .AND. xlocal    <=  -1.5D0)&
    RESULT = (2.D0*xlocal + 5.D0)**3/48.D0
    iF (xlocal>=  -1.5D0 .AND. xlocal    <=  -0.5D0)&
    RESULT = -(16.D0*xlocal**3+60.D0*xlocal**2+60.D0*xlocal+5.D0)/24.0D0
    iF (xlocal>=  -0.5D0 .AND. xlocal    <=  0.5D0)&
    RESULT = (xlocal*(4.D0*xlocal**2-5.D0))/4.0D0
    iF (xlocal>=  0.5D0 .AND. xlocal    <=  1.5D0)&
    RESULT = -(16.D0*xlocal**3-60.D0*xlocal**2+60.D0*xlocal-5.D0)/24.0D0
    iF (xlocal>=  1.5D0 .AND. xlocal    <=  2.5D0)&
    RESULT = (8.D0*xlocal**3-60.D0*xlocal**2+150.D0*xlocal-125.D0)/48.D0
            
           ELSE  iF (kod == 2) THEN

    !        *********** DRUGA DERiVAcijA **********

IF (xlocal>=  -2.5D0 .AND. xlocal    <=  -1.5D0)&
    RESULT = (2.D0*xlocal + 5.D0)**2/8.D0
    iF (xlocal>=  -1.5D0 .AND. xlocal    <=  -0.5D0)&
    RESULT = -(4.D0*xlocal**2+10.D0*xlocal+5.D0)/2.0D0
    iF (xlocal>=  -0.5D0 .AND. xlocal    <=  0.5D0)&
    RESULT = (12.D0*xlocal**2-5.D0)/4.0D0
    iF (xlocal>=  0.5D0 .AND. xlocal    <=  1.5D0)&
    RESULT = -(4.D0*xlocal**2-10.D0*xlocal+5.D0)/2.0D0
    iF (xlocal>=  1.5D0 .AND. xlocal    <=  2.5D0)&
    RESULT = (4.D0*xlocal**2-20.D0*xlocal+25.D0)/8.D0


ELSE  iF (kod == 3) THEN

    !        *********** TRECA DERiVAcijA **********
				
iF (xlocal>=  -2.5D0 .AND. xlocal    <=  -1.5D0)&
    RESULT = (2.D0*xlocal + 5.D0)/2.D0
    iF (xlocal>=  -1.5D0 .AND. xlocal    <=  -0.5D0)&
    RESULT = -4.D0*xlocal-5.D0
    iF (xlocal>=  -0.5D0 .AND. xlocal    <=  0.5D0)&
    RESULT = 6.D0*xlocal
    iF (xlocal>=  0.5D0 .AND. xlocal    <=  1.5D0)&
    RESULT = -4.D0*xlocal+5.D0
    iF (xlocal>=  1.5D0 .AND. xlocal    <=  2.5D0)&
    RESULT = (2.D0*xlocal - 5.D0)/2.D0


   ELSE  iF (kod == 4) THEN

    !        *********** CETVRTA DERiVAcijA **********
				
iF (xlocal >=  -2.5D0 .AND. xlocal    <=  -1.5D0)&
    RESULT = 1.D0
    iF (xlocal>=  -1.5D0 .AND. xlocal    <=  -0.5D0)&
    RESULT = -4.D0
    iF (xlocal>=  -0.5D0 .AND. xlocal    <=  0.5D0)&
    RESULT = 6.D0
    iF (xlocal>=  0.5D0 .AND. xlocal    <=  1.5D0)&
    RESULT = -4.D0
    iF (xlocal>=  1.5D0 .AND. xlocal    <=  2.5D0)&
    RESULT = 1.D0

ELSE 

WRiTE (*,*)   'RED  DERiVAcijE  iZVAN  DOPUSTENOG  0 - 4'


        END iF

            !Derivative value
            RESULT=RESULT/deltax**kod   !***!
AlgSplineB04 = RESULT! VRACA 1 BROj, ODNOSNO VRACA VRijEDNOST ALGSPLiNEB03 U TOCki xpoint


    END FUNCTiON AlgSplineB04
        

END MODULE SPLINE_1_4_D

MODULE BASIS_STR

  TYPE  BasisFun
   REAL (kind=8),  allocatable, dimension(:) :: MCOX    !MODIFICATION COEFFICIENT FOR BASIS FUNCTIONS x-DIRECTION
   REAL (kind=8),  allocatable, dimension(:) :: MCOY    !MODIFICATION COEFFICIENT FOR BASIS FUNCTIONS y-DIRECTION
   REAL (kind=8),  allocatable, dimension(:) :: MCOZ    !MODIFICATION COEFFICIENT FOR BASIS FUNCTIONS z-DIRECTION
   
   INTEGER(kind=4), allocatable, dimension(:) :: ORDE    !ORDER OF BASIS FUNCTIONS
   
   REAL (kind=8),  allocatable, dimension(:) :: XVER    !BASIS FUNCTIONS VERTEX COORDINATE x-DIRECTION
   REAL (kind=8),  allocatable, dimension(:) :: YVER    !BASIS FUNCTIONS VERTEX COORDINATE y-DIRECTION
   REAL (kind=8),  allocatable, dimension(:) :: ZVER    !BASIS FUNCTIONS VERTEX COORDINATE z-DIRECTION
   
   REAL (kind=8),  allocatable, dimension(:) :: XGVE    !GREVILLE VERTEX COORDINATE x-DIRECTION
   REAL (kind=8),  allocatable, dimension(:) :: YGVE    !GREVILLE VERTEX COORDINATE y-DIRECTION
   REAL (kind=8),  allocatable, dimension(:) :: ZGVE    !GREVILLE VERTEX COORDINATE z-DIRECTION   

   INTEGER(kind=4), allocatable, dimension(:) :: IXGR    !INDEX GREEVILE x-DIRECTION 0-DOESN'T CHANGE,1-> NEEDS GREVILE MODIFICATION
   INTEGER(kind=4), allocatable, dimension(:) :: IYGR    !INDEX GREEVILE y-DIRECTION 0-DOESN'T CHANGE,1-> NEEDS GREVILE MODIFICATION
   INTEGER(kind=4), allocatable, dimension(:) :: IZGR    !INDEX GREEVILE z-DIRECTION 0-DOESN'T CHANGE,1-> NEEDS GREVILE MODIFICATION
         
   REAL (kind=8),  allocatable, dimension(:) :: XGKN    !x-direction greville knot vector
   REAL (kind=8),  allocatable, dimension(:) :: YGKN    !y-direction greville knot vector
   REAL (kind=8),  allocatable, dimension(:) :: ZGKN    !z-direction greville knot vector
              
   REAL (kind=8),  allocatable, dimension(:) :: DELX    !BASIS FUNCTIONS CHARACTERISTIC SEGMENT SIZE x-DIRECTION
   REAL (kind=8),  allocatable, dimension(:) :: DELY    !BASIS FUNCTIONS CHARACTERISTIC SEGMENT SIZE y-DIRECTION
   REAL (kind=8),  allocatable, dimension(:) :: DELZ    !BASIS FUNCTIONS CHARACTERISTIC SEGMENT SIZE z-DIRECTION
         
   INTEGER(kind=4), allocatable, dimension(:) :: DERI    !DERIVATION ORDER
   INTEGER(kind=4), allocatable, dimension(:) :: DERX    !DERIVATION ORDER x-direction
   INTEGER(kind=4), allocatable, dimension(:) :: DERY    !DERIVATION ORDER y-direction
   INTEGER(kind=4), allocatable, dimension(:) :: DERZ    !DERIVATION ORDER z-direction
   
   INTEGER(kind=4), allocatable, dimension(:) :: POSI    !BASIS FUNCTIONS POSITION IN THE TOTAL BASIS LAYOUT   
   INTEGER(kind=4), allocatable, dimension(:) :: POSX    !BASIS FUNCTIONS POSITION x-DIRECTION 1st layout
   INTEGER(kind=4), allocatable, dimension(:) :: POSY    !BASIS FUNCTIONS POSITION y-DIRECTION 1st layout
   INTEGER(kind=4), allocatable, dimension(:) :: POSZ    !BASIS FUNCTIONS POSITION z-DIRECTION 1st layout

   INTEGER(kind=4), allocatable, dimension(:) :: BFPX    !BASIS FUNCTIONS POSITION x-DIRECTION (For modified boundary b.f./Normal b.f.)
   INTEGER(kind=4), allocatable, dimension(:) :: BFPY    !BASIS FUNCTIONS POSITION y-DIRECTION (For modified boundary b.f./Normal b.f.)
   INTEGER(kind=4), allocatable, dimension(:) :: BFPZ    !BASIS FUNCTIONS POSITION z-DIRECTION (For modified boundary b.f./Normal b.f.)
            
   INTEGER(kind=4), allocatable, dimension(:) :: COUN    !TOTAL NUMBER OF BASIS FUNCTIONS DEPENDING ON THE ORDER
   
   INTEGER(kind=4), allocatable, dimension(:) :: ADAP    !ADAPTATION INTEGER (0->BASIS F. REMAINS; 1->BASIS F. GOES INTO ADAPTATION)
   
   INTEGER(kind=4), allocatable, dimension(:) :: ALIV    !ALIVE OR DEAD BASIS FUNCTION
   
   INTEGER(kind=4), allocatable, dimension(:) :: USED    !IS BASIS FUNTION USED(0->NOT USED; 1->USED)   
   
   INTEGER(kind=4), allocatable, dimension(:) :: CLVL    !CURRENT LEVEL OF THE BASIS FUNCTION 
    
   REAL (kind=8),  allocatable, dimension(:) :: BCOE    !BASIS COEFFICIENT (RIGHT SIDE VECTOR)
   
   INTEGER(kind=4), allocatable, dimension(:) :: TOTA    !TOTAL NUMBER OF BASIS FUNCTIONS
   
   INTEGER(kind=4), allocatable, dimension(:) :: IND_GRID1        !INDEX FIELD FOR 1-D SET OF B.F.
   INTEGER(kind=4), allocatable, dimension(:) :: IND_GRID1_OLD    !INDEX FIELD FOR 1-D SET OF B.F.
   
   INTEGER(kind=4), allocatable, dimension(:,:) :: IND_GRID2        !INDEX FIELD FOR 2-D SET OF B.F.
   INTEGER(kind=4), allocatable, dimension(:,:) :: IND_GRID2_OLD    !INDEX FIELD FOR 2-D SET OF B.F.
   
   INTEGER(kind=4), allocatable, dimension(:,:,:) :: IND_GRID3        !INDEX FIELD FOR 3-D SET OF B.F.
   INTEGER(kind=4), allocatable, dimension(:,:,:) :: IND_GRID3_OLD    !INDEX FIELD FOR 3-D SET OF B.F.
  END TYPE BasisFun
  
  TYPE  ControlV
   REAL (kind=8),  allocatable, dimension(:)  :: CVX1    !CONTROL VOLUME LEFT BOTTOM EDGE (X,y)
   REAL (kind=8),  allocatable, dimension(:)  :: CVY1    !CONTROL VOLUME LEFT BOTTOM EDGE (x,Y)
   
   REAL (kind=8),  allocatable, dimension(:)  :: CVX2    !CONTROL VOLUME RIGHT BOTTOM EDGE (X,y)
   REAL (kind=8),  allocatable, dimension(:)  :: CVY2    !CONTROL VOLUME RIGHT BOTTOM EDGE (x,Y)
   
   REAL (kind=8),  allocatable, dimension(:)  :: CVX3    !CONTROL VOLUME RIGHT TOP EDGE (X,y)
   REAL (kind=8),  allocatable, dimension(:)  :: CVY3    !CONTROL VOLUME RIGHT TOP EDGE (x,Y)
   
   REAL (kind=8),  allocatable, dimension(:)  :: CVX4    !CONTROL VOLUME LEFT TOP EDGE (X,y)
   REAL (kind=8),  allocatable, dimension(:)  :: CVY4    !CONTROL VOLUME LEFT TOP EDGE (x,Y)
  END TYPE ControlV
  
  TYPE GeometryB_Rep
   CHARACTER (len=20), allocatable, dimension(:)  :: LineType !Line type (strait line, NURBS, arc, etc.)
    
   REAL (kind=8),  allocatable, dimension(:)  :: X1    !LEFT BOTTOM EDGE (X,y,z)
   REAL (kind=8),  allocatable, dimension(:)  :: Y1    !LEFT BOTTOM EDGE (x,Y,z)
   REAL (kind=8),  allocatable, dimension(:)  :: Z1    !LEFT BOTTOM EDGE (x,y,Z)
   
   REAL (kind=8),  allocatable, dimension(:)  :: X2    !RIGHT BOTTOM EDGE (X,y,z)
   REAL (kind=8),  allocatable, dimension(:)  :: Y2    !RIGHT BOTTOM EDGE (x,Y,z)
   REAL (kind=8),  allocatable, dimension(:)  :: Z2    !RIGHT BOTTOM EDGE (x,y,Z)
   
   REAL (kind=8),  allocatable, dimension(:)  :: X3    !RIGHT BOTTOM EDGE (X,y,z)
   REAL (kind=8),  allocatable, dimension(:)  :: Y3    !RIGHT BOTTOM EDGE (x,Y,z)
   REAL (kind=8),  allocatable, dimension(:)  :: Z3    !RIGHT BOTTOM EDGE (x,y,Z)
  END TYPE GeometryB_Rep
   
  
END MODULE BASIS_STR

MODULE Geometry
	!for each nVar define Geometry
	!Subroutine Input_Geometry_Data
	use FUP_0_16_D
	use SPLINE_1_4_D
	use BASIS_STR
	implicit none
	
!Private	
	PRIVATE
		Integer(kind=4), parameter:: fileReadGeo=150
		Integer(kind=4) :: iiGeom, jjGeom, nLines, Dummy1, Dummy2
		Real (kind=8)   :: x1, y1, x2, y2, x3, y3
		CHARACTER(len=20) :: InputGeometryFile
		TYPE(GeometryB_Rep),DIMENSION(:),ALLOCATABLE :: LinesGeo   !Structure holding inf. about Line types and coordinate/control points 
!Public
	PUBLIC x1, y1, x2, y2, x3, y3, nLines
	PUBLIC INPUT_Geometry_Data, InputGeometryFile
	PUBLIC LinesGeo
	CONTAINS
	
		Subroutine INPUT_Geometry_Data
			print*, " "
			print*, "Geometry modul..."
			print*, " "
			OPEN(fileReadGeo, FILE = InputGeometryFile , STATUS = 'unknown', form = 'formatted')	 
			READ(fileReadGeo, *) Dummy1
			READ(fileReadGeo, *) Dummy2 !dimension
			READ(fileReadGeo, *) nLines
			
			if(allocated(LinesGeo)) deallocate (LinesGeo)
			ALLOCATE(LinesGeo(1))
			ALLOCATE(LinesGeo(1)%LineType(nLines),LinesGeo(1)%X1(nLines),LinesGeo(1)%Y1(nLines),LinesGeo(1)%Z1(nLines)&
					                             ,LinesGeo(1)%X2(nLines),LinesGeo(1)%Y2(nLines),LinesGeo(1)%Z2(nLines)&
					                             ,LinesGeo(1)%X3(nLines),LinesGeo(1)%Y3(nLines),LinesGeo(1)%Z3(nLines))
			Do iiGeom=1, nLines
			READ(fileReadGeo, *) LinesGeo(1)%LineType(iiGeom)
				If(Dummy2.eq.1) then
				 READ(fileReadGeo, *) LinesGeo(1)%X1(iiGeom), LinesGeo(1)%Y1(iiGeom)
				Else if(Dummy2.eq.2) then
				 READ(fileReadGeo, *) LinesGeo(1)%X1(iiGeom), LinesGeo(1)%Y1(iiGeom), LinesGeo(1)%X2(iiGeom), LinesGeo(1)%Y2(iiGeom)
				Else
				 write(*,*) "3-D needs to be implemented..."
				 read(*,*)
				End if

			End Do !iiGeom
			close(UNIT=fileReadGeo)

		End Subroutine INPUT_Geometry_Data
END MODULE Geometry

MODULE Material
	!Subroutine Input_Material_Data
	use FUP_0_16_D
	use SPLINE_1_4_D
	use BASIS_STR
	implicit none
	
!Private	
	PRIVATE
		Integer(kind=4), parameter:: fileReadMat=250
		Integer(kind=4) :: iiMat, DummyMat1, DummyMat2
		Real (kind=8)   :: Diff_const
		CHARACTER(len=20) :: Material_1, InputMaterialFile
!Public
	PUBLIC Diff_const, Material_1
	PUBLIC INPUT_Material_Data, InputMaterialFile
	CONTAINS
	
		Subroutine INPUT_Material_Data
			print*, "Material modul - work in progress..."
			OPEN(fileReadMat, FILE = InputMaterialFile , STATUS = 'unknown', form = 'formatted')	 
			READ(fileReadMat, *) DummyMat1
			READ(fileReadMat, *) DummyMat2
			READ(fileReadMat, *) Material_1
			close(UNIT=fileReadMat)
		End Subroutine INPUT_Material_Data
END MODULE Material

MODULE Loading
	!Subroutine Input_Loading_Data
	use FUP_0_16_D
	use SPLINE_1_4_D
	use BASIS_STR
	implicit none
	
!Private	
	PRIVATE
		Integer(kind=4), parameter:: fileReadLoad=350
		Integer(kind=4) :: iiLoad
		Real (kind=8)   :: DummyLoad
		CHARACTER(len=20) :: InputLoadingFile
!Public
	PUBLIC DummyLoad
	PUBLIC INPUT_Loading_Data, InputLoadingFile
	CONTAINS
	
		Subroutine INPUT_Loading_Data
			print*, "Loading modul - work in progress..."
			OPEN(fileReadLoad, FILE = InputLoadingFile , STATUS = 'unknown', form = 'formatted')	 
			READ(fileReadLoad, *) DummyLoad
			close(UNIT=fileReadLoad)
		End Subroutine INPUT_Loading_Data
END MODULE Loading

MODULE Global_Data
!Use Global_Data for input/output
  !Global_Data for each variable nVar
	!Basis function type
	!Modified or Unmodified (edge) basis functions
	!Basis functions order (first level)
	!Max level
	!Formulation type (Galerkin, Control Volume, Collocation, etc.) 
	!Linear/Non-linear problem type
	!Solving type (IGA, IMGA)
	!Integration type (nGauss)
	!Solver type (Pardiso, Simq, BANDSol, PETSc, Hypre)
	!Dimension spatial
	!Resolution for all spatial dimensions (jmin_x, jmin_y, jmin_z)
	!Dimension temporal
	!Resolution for time dimension (jmin_t, d_t0)
	!Number of operators 
	!List of operators (i.e., diffusion linear/non-linear, advection linear/non-linear,
	!Time term linear/non-linear, source term linear/non-linear)
	!Geometry ()
	!Material
	
	use FUP_0_16_D
	use SPLINE_1_4_D
	use BASIS_STR
	use Geometry
	use Material
	use Loading
	
	Implicit none
	
	PRIVATE 
		Integer(kind=4), parameter:: lunF1=100, fileRead=150
		Integer(kind=4) :: iiInput, jjInput, nVar, nOrder, nnbfx, nnbfy, nnbfz, nnbfT, MaxLevel, nGauss, DummyInpt
		Integer(kind=4) :: jmin_x, jmin_y, jmin_z,DimenSpat, jmin_t, DimenTime, LastLvl, CurrLvl
		Integer(kind=4) :: nBF_IND_GRIDi,nBF_IND_GRIDj, nBF_IND_GRID_T 
		Real (kind=8) :: d_t0, pi, ch_lenX, ch_lenY, ch_lenZ
		Real (kind=8), allocatable, dimension(:,:) :: wGauss
		CHARACTER(len=20) :: ReadFile, BasisType, EdgeModif, Formulation, Linear_NonLinear, SolType, IntegType, Solver
		TYPE(BasisFun), DIMENSION(:),ALLOCATABLE :: BasFun   !Structure holding inf. about basis functions
		TYPE(BasisFun), DIMENSION(:),ALLOCATABLE :: INDGRID_IJK
!~ 		TYPE(BasisFun), TARGET, DIMENSION(:),ALLOCATABLE :: BasFun   !Structure holding inf. about basis functions
!~ 		TYPE(BasisFun), POINTER , DIMENSION(:):: P_BF
	PUBLIC Input_Global_Data, nOrder, BasisType, MaxLevel, Formulation, Linear_NonLinear, nGauss, wGauss
	PUBLIC jmin_x, jmin_y, jmin_z,DimenSpat, jmin_t, DimenTime, d_t0, EdgeModif, pi, BasFun, nnbfx, nnbfy, nnbfz, nnbfT
	PUBLIC CurrLvl, LastLvl, nBF_IND_GRIDi,nBF_IND_GRIDj, nBF_IND_GRID_T, INDGRID_IJK
	CONTAINS
	
	Subroutine INPUT_Global_Data
	    pi=4.D0*atan(1.0D0)
	    !Current level is set to 1 (later is changed according to active resolution level if adaptation is included)
	    CurrLvl=1
	    
		Print*, "Loading input data..."
		WRITE(*,*) "     Input data file name --------> "
		READ(* ,'(A)') ReadFile

		OPEN(fileRead, FILE = ReadFile , STATUS = 'unknown', form = 'formatted')	 
		READ(fileRead, *) nVar,nOrder,BasisType, EdgeModif, MaxLevel, Formulation,Linear_NonLinear
		READ(fileRead, *) SolType, IntegType, nGauss, Solver
		READ(fileRead, *) DimenSpat, jmin_x, jmin_y, jmin_z, DimenTime, jmin_t, d_t0
		READ(fileRead, *) InputGeometryFile
		READ(fileRead, *) InputMaterialFile
		READ(fileRead, *) InputLoadingFile	
		close(UNIT=fileRead)
		wGauss=gaussquad(nGauss)
			
		call INPUT_Geometry_Data
!~ 		call INPUT_Material_Data
!~ 		call INPUT_Loading_Data
			
		print*, "Order of basis function: ", nOrder
		print*, "Basis function type: ", BasisType
		print*, "Maximum level :", MaxLevel
		print*, "Formulation type: ", Formulation, Linear_NonLinear, "problem"
		print*, SolType
		print*, "Using :",IntegType, "integration with ", nGauss, " points"
		print*, "Using :", Solver, " solver"
		print*, "Dimension: ", DimenSpat
		print*, InputGeometryFile
		print*, InputMaterialFile
		print*, InputLoadingFile
			
		print*, " "
		do iiInput=1, nLines
		print*, "Coordinates for the ", iiInput, "-", LinesGeo(1)%LineType(iiInput),"are:",LinesGeo(1)%X1(iiInput),LinesGeo(1)%Y1(iiInput)
		end do 
		print*, " "
		do iiInput=1, nGauss
		print*, iiInput, "Gauss node: ", wGauss(1,iiInput), "weight ", wGauss(2,iiInput)
		end do
		print*, " "
		
		!Fill basis fucntion struction with information
		call PrepareBFData
		
		print*, "Basis functions for ", DimenSpat,"-D :"
		do iiInput=1, nnbfT
		 print*, iiInput, BasFun(1)%MCOX(iiInput), BasFun(1)%ORDE(iiInput), BasFun(1)%DELX(iiInput)
		 print*, "i,j: ", BasFun(1)%POSX(iiInput),BasFun(1)%POSY(iiInput)
		 print*, "Vertices: ", BasFun(1)%XVER(iiInput),BasFun(1)%YVER(iiInput)
		 print*, " "
		end do
		
		print*, "i 15. bazne funkcije je: ",BasFun(1)%POSX(15)
		print*, "j 15. bazne funkcije je: ",BasFun(1)%POSY(15)
		

		print*, Mod(4,2)
		print*, MOD(5,2)
		print*, " -- "
		
		!number of b.f. on first res.lvl
		!print number of b.f. on other resolution level depending on max level
		DummyInpt=4
		Do iiInput=1, 5
		 DummyInpt=2*DummyInpt-1
		 print*, iiInput+1, " level", DummyInpt
		End do
		
!~ 		call Diffusion_Linear
	End Subroutine Input_Global_Data
		
	Function gaussquad(ngauss) result(wGauss)
	!Calculates gauss-legendre nodes x_{i} r(1,ii) and appropriate weights w_{i} r(2,ii)
	!Works with gfortran but needs the option 
	!   -assume realloc_lhs
	!when compiled with Intel Fortran.
	Integer (kind=4)          :: ngauss
	Real(kind=8)              :: wGauss(2, ngauss), x, f, df, dx
	Integer (kind=4)          :: igaus, kgaus,  iter
	Real(kind=8), allocatable :: p0(:), p1(:), tmp(:)
 
	p0 = [1.D0]
	p1 = [1.D0, 0.D0]
 
	do kgaus = 2, ngauss
     tmp = ((2*kgaus-1)*[p1,0.D0]-(kgaus-1)*[0.D0, 0.D0,p0])/kgaus
     p0 = p1; p1 = tmp
	end do
	do igaus = 1, ngauss
		x = cos(pi*(igaus-0.25D0)/(ngauss+0.5D0))
		do iter = 1, 10
		f = p1(1); df = 0.D0
			do kgaus = 2, size(p1)
				df = f + x*df
				f  = p1(kgaus) + x * f
			end do
		  dx =  f / df
		  x = x - dx
          if (abs(dx)<10*epsilon(dx)) exit
		end do
      wGauss(1,igaus) = x
      wGauss(2,igaus) = 2/((1-x**2)*df**2)
	end do
  
   End Function gaussquad
	
	Subroutine PrepareBFData
    Integer(kind=4) :: iiPD, jjPD, kkPD, llPD, iiGRID, jjGRID
    !Distance between (vertices) basis functons on the first (uniform) level
    !characheristic length x/y/z defined via jmin parameter 
    !ch_lenX= (LinesGeo(1)%X2(1) - LinesGeo(1)%X1(1))/(2**jmin_x) !x-direction   
   
    !To ensure IND_GRID array to allocate properly we must prepare array as if max level was even.
    if(MOD(MaxLevel,2).EQ.(1)) LastLvl=MaxLevel+1
    if(MOD(MaxLevel,2).EQ.(0)) LastLvl=MaxLevel
    
    if(DimenSpat.eq.1) then
     ch_lenX= (LinesGeo(1)%X2(1) - LinesGeo(1)%X1(1))/(2**jmin_x)
	 nnbfx=2**(jmin_x)+nOrder+1
     nnbfT=nnbfx
     
     !Prepare IND_GRID ARRAY SIZE
     nBF_IND_GRIDi=nnbfx
     Do iiInput=1, LastLvl-1
		nBF_IND_GRIDi=2*nBF_IND_GRIDi-1
	 End do
     nBF_IND_GRID_T=nBF_IND_GRIDi
     
     if(nnbfx.LT.(nOrder+1)*2) write(*,*) "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
     if(nnbfx.LT.(nOrder+1)*2) write(*,*) "!!!Problems with edge basis functions, change (increase) jminx/y/z!!!"
     if(nnbfx.LT.(nOrder+1)*2) write(*,*) "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
     if(nnbfx.LT.(nOrder+1)*2) read(*,*) 

   !Allocate memory for structure
     if(allocated(BasFun)) deallocate (BasFun)
     ALLOCATE(BasFun(nVar))

	ALLOCATE(BasFun(nVar)%MCOX(nnbfT),BasFun(nVar)%MCOY(nnbfT),BasFun(nVar)%MCOZ(nnbfT),BasFun(nVar)%ORDE(nnbfT),&
			 BasFun(nVar)%DELX(nnbfT),BasFun(nVar)%DELY(nnbfT),BasFun(nVar)%DELZ(nnbfT),&
			 BasFun(nVar)%POSI(nnbfT),BasFun(nVar)%POSX(nnbfT),BasFun(nVar)%POSY(nnbfT),BasFun(nVar)%COUN(nnbfT),&
			 BasFun(nVar)%ADAP(nnbfT),BasFun(nVar)%USED(nnbfT),BasFun(nVar)%XVER(nnbfT),BasFun(nVar)%YVER(nnbfT),&
			 BasFun(nVar)%BFPX(nnbfT),BasFun(nVar)%BFPY(nnbfT),BasFun(nVar)%CLVL(nnbfT),&
			 BasFun(nVar)%IXGR(nnbfT),BasFun(nVar)%IYGR(nnbfT),BasFun(nVar)%XGVE(nnbfT),BasFun(nVar)%YGVE(nnbfT),&
			 BasFun(nVar)%BCOE(nnbfT),&
			 BasFun(nVar)%DERX(nnbfT),BasFun(nVar)%DERY(nnbfT),BasFun(nVar)%DERZ(nnbfT) )
 
 
	!Prepare first level data (vertices, b.f. modification coefficients, indexes, etc.)
	kkPD=1 !x-DIRECTION COUNTER         
	Do iiPD=1, nnbfT
	BasFun(1)%MCOX(iiPD)=BICO(nOrder,1)
	BasFun(1)%ORDE(iiPD)=nOrder
	BasFun(1)%DELX(iiPD)=ch_lenX
	BasFun(1)%POSI(iiPD)=iiPD
	BasFun(1)%DERX(iiPD)=0
	BasFun(1)%ADAP(iiPD)=0
	BasFun(1)%CLVL(iiPD)=CurrLvl
	BasFun(1)%COUN(iiPD)=(nOrder+1)*2+1 !-> Modified boundary b.f. (both left and right boundary) + 1 normal b.f.
	BasFun(1)%XVER(iiPD)=LinesGeo(1)%X1(1) -dfloat(((nOrder+1)/2))*(ch_lenX) + mod(nOrder,2)*(ch_lenX/2.D0)+(kkPD-1)*(ch_lenX)
	BasFun(1)%POSX(iiPD)=kkPD
  
	kkPD=kkPD+1
	End Do
	
   else if(DimenSpat.eq.2) then
     !2-D basis functions
     ch_lenX= (LinesGeo(1)%X1(2) - LinesGeo(1)%X1(1))/(2**jmin_x)
     nnbfx=2**(jmin_x)+nOrder+1
     nnbfy=2**(jmin_y)+nOrder+1
     ch_lenY= (LinesGeo(1)%Y1(4) - LinesGeo(1)%Y1(1))/(2**jmin_y)
     nnbfT=nnbfx*nnbfy
     
     !Prepare IND_GRID ARRAY SIZE
     nBF_IND_GRIDi=nnbfx
     nBF_IND_GRIDj=nnbfy
     Do iiInput=1, LastLvl-1
		nBF_IND_GRIDi=2*nBF_IND_GRIDi-1
		nBF_IND_GRIDj=2*nBF_IND_GRIDj-1
	 End do
	 nBF_IND_GRID_T=nBF_IND_GRIDi*nBF_IND_GRIDj
	 
     if(nnbfx.LT.(nOrder+1)*2) write(*,*) "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
     if(nnbfx.LT.(nOrder+1)*2) write(*,*) "!!!Problems with edge basis functions, change (increase) jminx/y/z!!!"
     if(nnbfx.LT.(nOrder+1)*2) write(*,*) "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
     if(nnbfx.LT.(nOrder+1)*2) read(*,*) 

   !Allocate memory for structure
    if(allocated(BasFun)) deallocate (BasFun)
    if(allocated(INDGRID_IJK)) deallocate (INDGRID_IJK)
    
    ALLOCATE(BasFun(nVar))
	ALLOCATE(BasFun(nVar)%MCOX(nnbfT),BasFun(nVar)%MCOY(nnbfT),BasFun(nVar)%MCOZ(nnbfT),BasFun(nVar)%ORDE(nnbfT),&
			 BasFun(nVar)%DELX(nnbfT),BasFun(nVar)%DELY(nnbfT),BasFun(nVar)%DELZ(nnbfT),&
			 BasFun(nVar)%POSI(nnbfT),BasFun(nVar)%POSX(nnbfT),BasFun(nVar)%POSY(nnbfT),BasFun(nVar)%COUN(nnbfT),&
			 BasFun(nVar)%ADAP(nnbfT),BasFun(nVar)%USED(nnbfT),BasFun(nVar)%XVER(nnbfT),BasFun(nVar)%YVER(nnbfT),&
			 BasFun(nVar)%BFPX(nnbfT),BasFun(nVar)%BFPY(nnbfT),BasFun(nVar)%CLVL(nnbfT),&
			 BasFun(nVar)%IXGR(nnbfT),BasFun(nVar)%IYGR(nnbfT),BasFun(nVar)%XGVE(nnbfT),BasFun(nVar)%YGVE(nnbfT),&
			 BasFun(nVar)%BCOE(nnbfT),&
			 BasFun(nVar)%DERX(nnbfT),BasFun(nVar)%DERY(nnbfT),BasFun(nVar)%DERZ(nnbfT),&
			 BasFun(nVar)%IND_GRID2(nnbfx,nnbfy), BasFun(nVar)%IND_GRID2_OLD(nnbfx,nnbfy) )
 
	ALLOCATE( INDGRID_IJK(nVar))
	ALLOCATE( INDGRID_IJK(nVar)%IND_GRID2(nBF_IND_GRIDi,nBF_IND_GRIDj),INDGRID_IJK(nVar)%IND_GRID2_OLD(nBF_IND_GRIDi,nBF_IND_GRIDj),&
			  INDGRID_IJK(nVar)%BFPX(nBF_IND_GRID_T),INDGRID_IJK(nVar)%BFPY(nBF_IND_GRID_T),INDGRID_IJK(nVar)%ALIV(nBF_IND_GRID_T),&
			  INDGRID_IJK(nVar)%COEF(nBF_IND_GRID_T))
    
    kkPD=1 !x-DIRECTION COUNTER
	llPD=1 !y-DIRECTION COUNTER   
    !Prepare max lvl IND_GRID array with active/dead basis fucntions index, and i/j/k
    Do iiPD=1, nBF_IND_GRID_T
     INDGRID_IJK(nVar)%BFPX(iiPD)=kkPD
     INDGRID_IJK(nVar)%BFPY(iiPD)=llPD
     INDGRID_IJK(nVar)%ALIV(iiPD)=0
!~      print*, iiPD, INDGRID_IJK(nVar)%BFPX(iiPD), INDGRID_IJK(nVar)%BFPY(iiPD)
     kkPD=kkPD+1
	 if(kkPD.gt.nBF_IND_GRIDi) llPD=llPD+1
	 if(kkPD.gt.nBF_IND_GRIDi) kkPD=1
    End do !Max level prepare
    
    
	!Prepare first level (uniform) data (vertices, b.f. modification coefficients, indexes, etc.)
	kkPD=1 !x-DIRECTION COUNTER
	llPD=1 !y-DIRECTION COUNTER          
	iiPD=1 
	Do iiGRID=1, nBF_IND_GRIDi, 2**(LastLvl-CurrLvl)
	 Do jjGRID=1, nBF_IND_GRIDj, 2**(LastLvl-CurrLvl) 
	BasFun(nVar)%MCOX(iiPD)=BICO(nOrder,1)
	BasFun(nVar)%MCOY(iiPD)=BICO(nOrder,1)
	BasFun(nVar)%ORDE(iiPD)=nOrder
	BasFun(nVar)%DELX(iiPD)=ch_lenX
	BasFun(nVar)%DELY(iiPD)=ch_leny
	BasFun(nVar)%POSI(iiPD)=iiPD
	BasFun(nVar)%CLVL(nnbfT)=CurrLvl
	BasFun(nVar)%IND_GRID2(kkPD,llPD)=iiPD 
	BasFun(nVar)%DERY(iiPD)=0
	BasFun(nVar)%ADAP(iiPD)=0
	BasFun(nVar)%COUN(iiPD)=(nOrder+1)*2+1 !-> Modified boundary b.f. (both left and right boundary) + 1 normal b.f.
	BasFun(nVar)%XVER(iiPD)=LinesGeo(1)%X1(1) -dfloat(((nOrder+1)/2))*(ch_lenX) + mod(nOrder,2)*(ch_lenX/2.D0)+(kkPD-1)*(ch_lenX)
	BasFun(nVar)%YVER(iiPD)=LinesGeo(1)%Y1(1) -dfloat(((nOrder+1)/2))*(ch_lenY) + mod(nOrder,2)*(ch_lenY/2.D0)+(llPD-1)*(ch_lenY)
	BasFun(nVar)%POSX(iiPD)=kkPD
	BasFun(nVar)%POSY(iiPD)=llPD
    
    print*, iiPD,  BasFun(nVar)%XVER(iiPD), BasFun(nVar)%YVER(iiPD)
	kkPD=kkPD+1
	if(kkPD.gt.nnbfx) llPD=llPD+1
	if(kkPD.gt.nnbfx) kkPD=1
	iiPD=iiPD+1
	 End Do !jjGRID
	End do !iiGRID
	
!~ 	kkPD=1
!~ 	Do iiPD=1, nBF_IND_GRID_T, 2**(LastLvl-1)
!~ 	 print*, iiPD, kkPD
!~ 	 kkPD=kkPD+1
!~ 	End Do
	
   else
     !3-D     
     nnbfx=2**(jmin_x)+nOrder+1
     nnbfy=2**(jmin_y)+nOrder+1
     nnbfz=2**(jmin_z)+nOrder+1
     nnbfT=nnbfx*nnbfy*nnbfz
     write(*,*) "Work in progres..."
     read(*,*)
   end if
    
  
  end subroutine PrepareBFData
    
  Real(kind=8) function BICO(n,iii_k)
    !Returns BInom COefficient value
    !INPUT:
    !n-basis function order
    !iii_k- integer value (k=0,1,...,n+1)
    
        Integer(kind=4) n,iii_k
        
        if(BasisType.eq.'spline') BICO=1.D0/8.D0 !B3-spline
        
        if(BasisType.eq.'fup')  then
          
          Select case(n)
           Case (1)
            if(iii_k.eq.1) then
             BICO=1.D0/2.D0
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=1)"    
             end if
           Case(2)
             if(iii_k.eq.1) then
             BICO= 1.D0/4.D0
             
             else if(iii_k.eq.2) then
             BICO= 2.D0/4.D0
             
             else if(iii_k.eq.3) then
             BICO= 1.D0/4.D0
             
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=2)"    
            
             end if
           Case(3)
            if(iii_k.eq.1) then
             BICO= 1.D0/8.D0
             
             else if(iii_k.eq.2) then
             BICO= 3.D0/8.D0 
             
             else if(iii_k.eq.3) then
             BICO= 3.D0/8.D0

             else if(iii_k.eq.4) then
             BICO= 1.D0/8.D0
                          
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=3)"    
            
             end if
           Case(4)
            if(iii_k.eq.1) then
             BICO= 1.D0/16.D0
             
             else if(iii_k.eq.2) then
             BICO= 4.D0/16.D0 
             
             else if(iii_k.eq.3) then
             BICO= 6.D0/16.D0

             else if(iii_k.eq.4) then
             BICO= 4.D0/16.D0

             else if(iii_k.eq.5) then
             BICO= 1.D0/16.D0
                                       
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=4)"    
            
             end if
           Case(5)
            if(iii_k.eq.1) then
             BICO= 1.D0/32.D0
             
             else if(iii_k.eq.2) then
             BICO= 5.D0/32.D0 
             
             else if(iii_k.eq.3) then
             BICO= 10.D0/32.D0

             else if(iii_k.eq.4) then
             BICO= 10.D0/32.D0

             else if(iii_k.eq.5) then
             BICO= 5.D0/32.D0

             else if(iii_k.eq.6) then
             BICO= 1.D0/32.D0
                                                    
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=5)"    
            
             end if
           Case(6)
            if(iii_k.eq.1) then
             BICO= 1.D0/64.D0
             
             else if(iii_k.eq.2) then
             BICO= 6.D0/64.D0
             
             else if(iii_k.eq.3) then
             BICO= 15.D0/64.D0

             else if(iii_k.eq.4) then
             BICO= 20.D0/64.D0

             else if(iii_k.eq.5) then
             BICO= 15.D0/64.D0

             else if(iii_k.eq.6) then
             BICO= 6.D0/64.D0
             
             else if(iii_k.eq.7) then
             BICO= 1.D0/64.D0
                                                                                 
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=6)"    
            
            end if
           Case(7)
            if(iii_k.eq.1) then
             BICO= 1.D0/128.D0
             
             else if(iii_k.eq.2) then
             BICO= 7.D0/128.D0
             
             else if(iii_k.eq.3) then
             BICO= 21.D0/128.D0

             else if(iii_k.eq.4) then
             BICO= 35.D0/128.D0

             else if(iii_k.eq.5) then
             BICO= 35.D0/128.D0

             else if(iii_k.eq.6) then
             BICO= 21.D0/128.D0
             
             else if(iii_k.eq.7) then
             BICO= 7.D0/128.D0

             else if(iii_k.eq.8) then
             BICO= 1.D0/128.D0
                                                                                                           
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=7)"    
            
            end if
           Case(8)
            if(iii_k.eq.1) then
             BICO= 1.D0/256.D0
             
             else if(iii_k.eq.2) then
             BICO= 8.D0/256.D0
             
             else if(iii_k.eq.3) then
             BICO= 28.D0/256.D0

             else if(iii_k.eq.4) then
             BICO= 56.D0/256.D0

             else if(iii_k.eq.5) then
             BICO= 70.D0/256.D0

             else if(iii_k.eq.6) then
             BICO= 56.D0/256.D0
             
             else if(iii_k.eq.7) then
             BICO= 28.D0/256.D0

             else if(iii_k.eq.8) then
             BICO= 8.D0/256.D0

             else if(iii_k.eq.9) then
             BICO= 1.D0/256.D0
                                                                                              
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=8)"    
            
            end if
           Case(9)
            if(iii_k.eq.1) then
             BICO= 1.D0/512.D0
             
             else if(iii_k.eq.2) then
             BICO= 9.D0/512.D0
             
             else if(iii_k.eq.3) then
             BICO= 36.D0/512.D0

             else if(iii_k.eq.4) then
             BICO= 84.D0/512.D0

             else if(iii_k.eq.5) then
             BICO= 126.D0/512.D0

             else if(iii_k.eq.6) then
             BICO= 126.D0/512.D0
             
             else if(iii_k.eq.7) then
             BICO= 84.D0/512.D0

             else if(iii_k.eq.8) then
             BICO= 36.D0/512.D0

             else if(iii_k.eq.9) then
             BICO= 9.D0/512.D0

             else if(iii_k.eq.10) then
             BICO= 1.D0/512.D0      
                                                                                                     
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=9)"    
            
            end if
           Case(10)
            if(iii_k.eq.1) then
             BICO= 1.D0/1024.D0
             
             else if(iii_k.eq.2) then
             BICO= 10.D0/1024.D0
             
             else if(iii_k.eq.3) then
             BICO= 45.D0/1024.D0

             else if(iii_k.eq.4) then
             BICO= 120.D0/1024.D0

             else if(iii_k.eq.5) then
             BICO= 210.D0/1024.D0

             else if(iii_k.eq.6) then
             BICO= 252.D0/1024.D0
             
             else if(iii_k.eq.7) then
             BICO= 210.D0/1024.D0

             else if(iii_k.eq.8) then
             BICO= 120.D0/1024.D0

             else if(iii_k.eq.9) then
             BICO= 45.D0/1024.D0

             else if(iii_k.eq.10) then
             BICO= 10.D0/1024.D0      

             else if(iii_k.eq.11) then
             BICO= 1.D0/1024.D0  
                                                                                                                  
             else
             write(*,*) "check iii_k, only n+2 basis functions (n=10)"
                                                                                            
           end if
          End Select
        
        end if
    end function BICO
   
  Real(kind=8) function Fup2D(coe1,ord1,ver1,xx,chs1,der1,pos1,cou1,coe2,ord2,ver2,yy,chs2,der2,pos2,cou2)

!Returns value of 2D Fup basis functions
!----------------------------------------------------------
! IN:
! coe   - coefficients for modifing basis functions (1.0 if not necessary); e.g. 1/2 for Fup1 to preserve partition of unity!
! ord   - basis function order
! ver   - basis function vertex (x,y)
! chs   - characteristic segment size
! der   - derivation order
! pos   - position (modified edge or normal)
! cou   - if modified which one (first, second, ...etc.)
! OUT:
! Fup2D - value of 2D Fup basis function
!==========================================================
 Integer (kind=4) ord1,der1,pos1,cou1,ord2,der2,pos2,cou2
 Real   (kind=8) coe1,ver1,xx,chs1,coe2,ver2,yy,chs2, COE
        
        !COE = coe1_x*coe2_y
         COE=coe2
         COE=coe1
  Fup2D= COE*BFUNC(ord1,ver1,xx,chs1,der1,pos1,cou1)*BFUNC(ord2,ver2,yy,chs2,der2,pos2,cou2)

  end function Fup2D     
  
  Real(kind=8) function BFUNC(n,xv,xp,dx,deriv_deg,iii_N,N_bf)
    !Returns basis function value depending on is it modified (near edge) or regular basis function. Later that b.f. is multiplied 
    !with corresponding coefficient value (see BICO) of that basis functions. In doing that we are ensuring partition of unity!
    !Input - n         -> Basis function order
    !      - xv        -> Basis function vertex position
    !      - xp        -> point value in which we are interested
    !      - dx        -> characheristic segment size
    !      - deriv_deg -> derivation order
    !      - iii_N     -> position of basis function (e.g. 1./42.-(modified b.f.)| 18./42.- (normal) 
    !      - N_bf      -> total number of basis functions (used to check right side; is it modified or not)
        
        integer(4) n,deriv_deg, iii_N, N_bf
        real(8) xv,xp,dx
        
        if(BasisType.eq.'spline') BFUNC=splinen(n,xv,xp,dx,deriv_deg)
        
        if(BasisType.eq.'fup')  then
           
           if(n==1) then
            
             if(iii_n.eq.1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,1)
             
             else if(iii_n.eq.2) then
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                   fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,2)
               
             
             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                   fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)
              
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,1)
            
             else
             !without modification
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)
            
             end if
             
           else if(n==2) then
       
             if(iii_n.eq.1) then     
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,1)
            
             else if(iii_n.eq.2) then         
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,2)

             else if(iii_n.eq.3) then
             BFUNC=fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,3)
                               
             else if(iii_n.eq.N_bf-2) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)                  

             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)
                  
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,1)

             else 
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)               
             end if
             
             
           else if(n==3) then
             if(iii_n.eq.1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,1)
             
             else if(iii_n.eq.2) then
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)+&
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,2)

             else if(iii_n.eq.3) then
             BFUNC=fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,3)

             else if(iii_n.eq.4) then
             BFUNC=fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,4)

             else if(iii_n.eq.N_bf-3) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)
                                                                   
             else if(iii_n.eq.N_bf-2) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)                  

             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)
                  
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,1)

             else
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)
                            
             end if
             
           else if(n==4) then
             if(iii_n.eq.1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,1)
             
             else if(iii_n.eq.2) then
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)+&
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,2)

             else if(iii_n.eq.3) then
             BFUNC=fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,3)

             else if(iii_n.eq.4) then
             BFUNC=fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,4)

             else if(iii_n.eq.5) then
             BFUNC=fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,5)

             else if(iii_n.eq.N_bf-4) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)
                                    
             else if(iii_n.eq.N_bf-3) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)
                                                                   
             else if(iii_n.eq.N_bf-2) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)                  

             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)
                  
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,1)

             else
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)
                            
             end if

           else if(n==5) then
             if(iii_n.eq.1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,1)
             
             else if(iii_n.eq.2) then
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)+&
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,2)

             else if(iii_n.eq.3) then
             BFUNC=fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,3)

             else if(iii_n.eq.4) then
             BFUNC=fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,4)

             else if(iii_n.eq.5) then
             BFUNC=fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,5)

             else if(iii_n.eq.6) then
             BFUNC=fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,6)

             else if(iii_n.eq.N_bf-5) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)
                                    
             else if(iii_n.eq.N_bf-4) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)
                                    
             else if(iii_n.eq.N_bf-3) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)
                                                                   
             else if(iii_n.eq.N_bf-2) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)                  

             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)
                  
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,1)

             else
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)               
             end if

           else if(n==6) then
             if(iii_n.eq.1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,1)
             
             else if(iii_n.eq.2) then
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)+&
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,2)

             else if(iii_n.eq.3) then
             BFUNC=fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,3)

             else if(iii_n.eq.4) then
             BFUNC=fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,4)

             else if(iii_n.eq.5) then
             BFUNC=fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,5)

             else if(iii_n.eq.6) then
             BFUNC=fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,6)

             else if(iii_n.eq.7) then
             BFUNC=fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,7)

             else if(iii_n.eq.N_bf-6) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,7)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)
                                    
             else if(iii_n.eq.N_bf-5) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)
                                    
             else if(iii_n.eq.N_bf-4) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)
                                    
             else if(iii_n.eq.N_bf-3) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)
                                                                   
             else if(iii_n.eq.N_bf-2) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)                  

             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)
                  
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,1)

             else
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)
                            
             end if

           else if(n==7) then
             if(iii_n.eq.1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-4,1)
             
             else if(iii_n.eq.2) then
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,1)+&
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,2)

             else if(iii_n.eq.3) then
             BFUNC=fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,3)

             else if(iii_n.eq.4) then
             BFUNC=fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,4)

             else if(iii_n.eq.5) then
             BFUNC=fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,5)

             else if(iii_n.eq.6) then
             BFUNC=fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,6)

             else if(iii_n.eq.7) then
             BFUNC=fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,7)

             else if(iii_n.eq.8) then
             BFUNC=fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,7)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,8)

             else if(iii_n.eq.N_bf-7) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,8)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,7)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)
                                    
             else if(iii_n.eq.N_bf-6) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,7)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)
                                    
             else if(iii_n.eq.N_bf-5) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,6)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)
                                    
             else if(iii_n.eq.N_bf-4) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,5)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)
                                    
             else if(iii_n.eq.N_bf-3) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,4)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)
                                                                   
             else if(iii_n.eq.N_bf-2) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,3)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)                  

             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,2)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,1)
                  
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-4,1)

             else
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)
                            
             end if

           else if(n==8) then
             if(iii_n.eq.1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-4,1)
             
             else if(iii_n.eq.2) then
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,1)+&
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,2)

             else if(iii_n.eq.3) then
             BFUNC=fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,3)

             else if(iii_n.eq.4) then
             BFUNC=fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,4)

             else if(iii_n.eq.5) then
             BFUNC=fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,5)

             else if(iii_n.eq.6) then
             BFUNC=fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,6)

             else if(iii_n.eq.7) then
             BFUNC=fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,7)

             else if(iii_n.eq.8) then
             BFUNC=fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,7)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,8)

             else if(iii_n.eq.9) then
             BFUNC=fupn(n,xv-(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,1)+&
                  fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,2)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,3)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,4)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,5)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,6)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,7)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,8)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,4,9)

             else if(iii_n.eq.N_bf-8) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,4,9)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,8)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,7)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,6)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,5)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,4)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,3)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,2)+&
                  fupn(n,xv+(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,1)
                                    
             else if(iii_n.eq.N_bf-7) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,8)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,7)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)
                                    
             else if(iii_n.eq.N_bf-6) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,7)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)
                                    
             else if(iii_n.eq.N_bf-5) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,6)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)
                                    
             else if(iii_n.eq.N_bf-4) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,5)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)
                                    
             else if(iii_n.eq.N_bf-3) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,4)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)
                                                                   
             else if(iii_n.eq.N_bf-2) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,3)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)                  

             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,2)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,1)
                  
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-4,1)

             else
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)
                            
             end if

           else if(n==9) then
             if(iii_n.eq.1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-5,1)
             
             else if(iii_n.eq.2) then
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-4,1)+&
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-4,2)

             else if(iii_n.eq.3) then
             BFUNC=fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,1)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,2)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,3)

             else if(iii_n.eq.4) then
             BFUNC=fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,3)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,4)

             else if(iii_n.eq.5) then
             BFUNC=fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,4)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,5)

             else if(iii_n.eq.6) then
             BFUNC=fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,5)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,6)

             else if(iii_n.eq.7) then
             BFUNC=fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,6)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,7)

             else if(iii_n.eq.8) then
             BFUNC=fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,7)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,8)

             else if(iii_n.eq.9) then
             BFUNC=fupn(n,xv-(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)+&
                  fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,7)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,8)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,9)

             else if(iii_n.eq.10) then
             BFUNC=fupn(n,xv-(9.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,1)+&
                  fupn(n,xv-(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,2)+&
                  fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,3)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,4)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,5)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,6)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,7)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,8)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,9)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,4,10)

             else if(iii_n.eq.N_bf-9) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,4,10)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,9)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,8)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,7)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,6)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,5)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,4)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,3)+&
                  fupn(n,xv+(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,2)+&
                  fupn(n,xv+(9.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,1)
                                    
             else if(iii_n.eq.N_bf-8) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,9)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,8)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,7)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv+(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)
                                    
             else if(iii_n.eq.N_bf-7) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,8)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,7)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)
                                    
             else if(iii_n.eq.N_bf-6) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,7)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,6)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)
                                    
             else if(iii_n.eq.N_bf-5) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,6)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,5)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)
                                    
             else if(iii_n.eq.N_bf-4) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,5)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,4)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)
                                    
             else if(iii_n.eq.N_bf-3) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,4)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,3)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)
                                                                   
             else if(iii_n.eq.N_bf-2) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,3)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,2)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,1)                  

             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-4,2)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-4,1)
                  
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-5,1)

             else
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)
                            
             end if

           else if(n==10) then
             if(iii_n.eq.1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-5,1)
             
             else if(iii_n.eq.2) then
             BFUNC=fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-4,1)+&
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-4,2)

             else if(iii_n.eq.3) then
             BFUNC=fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,1)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,2)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,3)

             else if(iii_n.eq.4) then
             BFUNC=fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,3)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,4)

             else if(iii_n.eq.5) then
             BFUNC=fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,4)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,5)

             else if(iii_n.eq.6) then
             BFUNC=fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,5)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,6)

             else if(iii_n.eq.7) then
             BFUNC=fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,6)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,7)

             else if(iii_n.eq.8) then
             BFUNC=fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,7)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,8)

             else if(iii_n.eq.9) then
             BFUNC=fupn(n,xv-(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)+&
                  fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,7)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,8)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,9)

             else if(iii_n.eq.10) then
             BFUNC=fupn(n,xv-(9.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,1)+&
                  fupn(n,xv-(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,2)+&
                  fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,3)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,4)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,5)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,6)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,7)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,8)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,9)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,4,10)

             else if(iii_n.eq.11) then
             BFUNC=fupn(n,xv-(10.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,1)+&
                  fupn(n,xv-(9.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,2)+&
                  fupn(n,xv-(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,3)+&
                  fupn(n,xv-(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,4)+&
                  fupn(n,xv-(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,5)+&
                  fupn(n,xv-(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,6)+&
                  fupn(n,xv-(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,7)+&
                  fupn(n,xv-(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,8)+&
                  fupn(n,xv-(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,9)+&                
                  fupn(n,xv-(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,10)+&                
                  fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,5,11)

             else if(iii_n.eq.N_bf-10) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,5,11)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,10)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,9)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,8)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,7)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,6)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,5)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,4)+&
                  fupn(n,xv+(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,3)+&
                  fupn(n,xv+(9.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,2)+&
                  fupn(n,xv+(10.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,5,1)
                                    
             else if(iii_n.eq.N_bf-9) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,4,10)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,9)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,8)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,7)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,6)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,5)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,4)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,3)+&
                  fupn(n,xv+(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,2)+&
                  fupn(n,xv+(9.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,4,1)
                                    
             else if(iii_n.eq.N_bf-8) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,3,9)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,8)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,7)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,6)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,5)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,4)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,3)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,2)+&
                  fupn(n,xv+(8.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,3,1)
                                    
             else if(iii_n.eq.N_bf-7) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,2,8)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,7)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,6)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,5)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,4)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,3)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,2)+&
                  fupn(n,xv+(7.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,2,1)
                                    
             else if(iii_n.eq.N_bf-6) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,1,7)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,6)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,5)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,4)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,3)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,2)+&
                  fupn(n,xv+(6.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,1,1)
                                    
             else if(iii_n.eq.N_bf-5) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,0,6)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,5)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,4)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,3)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,2)+&
                  fupn(n,xv+(5.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,0,1)
                                    
             else if(iii_n.eq.N_bf-4) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-1,5)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,4)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,3)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,2)+&
                  fupn(n,xv+(4.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-1,1)
                                    
             else if(iii_n.eq.N_bf-3) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-2,4)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,3)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,2)+&                
                  fupn(n,xv+(3.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-2,1)
                                                                   
             else if(iii_n.eq.N_bf-2) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-3,3)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,2)+&
                  fupn(n,xv+(2.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-3,1)                  

             else if(iii_n.eq.N_bf-1) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-4,2)+&
                  fupn(n,xv+(1.D0)*dx,xp,dx,deriv_deg)*mod_coeff(n,-4,1)
                  
             else if(iii_n.eq.N_bf) then
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)*mod_coeff(n,-5,1)

             else
             BFUNC=fupn(n,xv,xp,dx,deriv_deg)
                            
             end if
                                                                                                        
           end if 
            
       end if
    
 end function
  
  Real(kind=8) function mod_coeff(nFUPO,nBF,nABC)
 !==========================================================
! Coefficient for modified value of fup_n(x) near edges [xa,xb]
! Modified on left edge [xa] or right edge [xb]
!----------------------------------------------------------
! IN:
! nFUPO - order of Fup_n ("n")
! nBF - basis function position 
! nABC - position of modified function ("A" - first one/ "B" - second one/... so on 
! OUT:
! mod_coeff - Value of modified fup basis function
!==========================================================
 !implicit none
 integer (kind=4), intent (in) :: nFUPO, nBF,nABC

!real (kind=8) mod_coeff

 IF (nFUPO.eq.1)  THEN  !Fup1
     IF (nBF.eq.-1) mod_coeff=(2.D0/1.D0)
     
     IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(-1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(1.D0/1.D0)
     END IF 
     
 ELSE IF (nFUPO.eq.2)  THEN  !Fup2
     IF (nBF.eq.-1) mod_coeff=(36.D0/5.D0)
     IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(-36.D0/5.D0)
           IF (nABC.eq.2)  mod_coeff=(18.D0/13.D0)
     ELSE IF (nBF.eq.1) THEN
           IF (nABC.eq.1)  mod_coeff=(1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(-5.D0/13.D0) 
           IF (nABC.eq.3)  mod_coeff=(1.D0/1.D0)
     END IF  

 ELSE IF (nFUPO.eq.3)  THEN  !Fup3
     IF (nBF.eq.-2) mod_coeff=(36.D0/1.D0)
     
     IF (nBF.eq.-1) THEN
           IF (nABC.eq.1)  mod_coeff=(-765.D0/16.D0)
           IF (nABC.eq.2)  mod_coeff=(45.D0/16.D0)
           
     ELSE IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(221.D0/16.D0)
           IF (nABC.eq.2)  mod_coeff=(-689.D0/336.D0) 
           IF (nABC.eq.3)  mod_coeff=(26.D0/21.D0)
           
     ELSE IF (nBF.eq.1) THEN
           IF (nABC.eq.1)  mod_coeff=(-1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(5.D0/21.D0) 
           IF (nABC.eq.3)  mod_coeff=(-5.D0/21.D0)         
           IF (nABC.eq.4)  mod_coeff=(1.D0/1.D0)
     END IF
     
 ELSE IF (nFUPO.eq.4)  THEN  !Fup4
     IF (nBF.eq.-2) mod_coeff=(32400.D0/143.D0)
     
     IF (nBF.eq.-1) THEN
           IF (nABC.eq.1)  mod_coeff=(-10737360.D0/31031.D0)
           IF (nABC.eq.2)  mod_coeff=(1620.D0/217.D0)
           
     ELSE IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(62069760.D0/441161.D0)
           IF (nABC.eq.2)  mod_coeff=(-3879360.D0/441161.D0) 
           IF (nABC.eq.3)  mod_coeff=(28800.D0/14231.D0)
           
     ELSE IF (nBF.eq.1) THEN
           IF (nABC.eq.1)  mod_coeff=(-43200.D0/2033.D0)
           IF (nABC.eq.2)  mod_coeff=(5852250.D0/2339983.D0) 
           IF (nABC.eq.3)  mod_coeff=(-18511200.D0/16379881.D0)         
           IF (nABC.eq.4)  mod_coeff=(1350.D0/1151.D0)
           
     ELSE IF (nBF.eq.2) THEN
           IF (nABC.eq.1)  mod_coeff=(1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(-199.D0/1151.D0) 
           IF (nABC.eq.3)  mod_coeff=(857.D0/8057.D0)         
           IF (nABC.eq.4)  mod_coeff=(-199.D0/1151.D0)
           IF (nABC.eq.5)  mod_coeff=(1.D0/1.D0)           
     END IF 

 ELSE IF (nFUPO.eq.5)  THEN  !Fup5
     IF (nBF.eq.-3) mod_coeff=(32400.D0/19.D0)
     
     IF (nBF.eq.-2) THEN
           IF (nABC.eq.1)  mod_coeff=(-635037975.D0/226081.D0)
           IF (nABC.eq.2)  mod_coeff=(289575.D0/11899.D0)
           
     ELSE IF (nBF.eq.-1) THEN
           IF (nABC.eq.1)  mod_coeff=(5087274375.D0/3700589.D0)
           IF (nABC.eq.2)  mod_coeff=(-140767125.D0/3700589.D0) 
           IF (nABC.eq.3)  mod_coeff=(93000.D0/22703.D0)
           
     ELSE IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(-25372050415500.D0/85040239013.D0)
           IF (nABC.eq.2)  mod_coeff=(1480626784500.D0/85040239013.D0) 
           IF (nABC.eq.3)  mod_coeff=(-343054417350.D0/85040239013.D0)         
           IF (nABC.eq.4)  mod_coeff=(6403950.D0/3745771.D0)
           
     ELSE IF (nBF.eq.1) THEN
           IF (nABC.eq.1)  mod_coeff=(109623542.D0/3745771.D0)
           IF (nABC.eq.2)  mod_coeff=(-151104458624.D0/53133761635.D0) 
           IF (nABC.eq.3)  mod_coeff=(53030980632.D0/53133761635.D0)         
           IF (nABC.eq.4)  mod_coeff=(-40916394862.D0/53133761635.D0)
           IF (nABC.eq.5)  mod_coeff=(16114.D0/14185.D0) 

     ELSE IF (nBF.eq.2) THEN
           IF (nABC.eq.1)  mod_coeff=(-1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(1929.D0/14185.D0) 
           IF (nABC.eq.3)  mod_coeff=(-857.D0/14185.D0)         
           IF (nABC.eq.4)  mod_coeff=(857.D0/14185.D0)
           IF (nABC.eq.5)  mod_coeff=(-1929.D0/14185.D0)   
           IF (nABC.eq.6)  mod_coeff=(1.D0/1.D0)          
     END IF

 ELSE IF (nFUPO.eq.6)  THEN  !Fup6
     IF (nBF.eq.-3) mod_coeff=(17146080.D0/1153.D0)
     
     IF (nBF.eq.-2) THEN
           IF (nABC.eq.1)  mod_coeff=(-32051791032660.D0/1252177601.D0)
           IF (nABC.eq.2)  mod_coeff=(101804850.D0/1086017.D0)
           
     ELSE IF (nBF.eq.-1) THEN
           IF (nABC.eq.1)  mod_coeff=(596311757347228650.D0/42730988524823.D0)
           IF (nABC.eq.2)  mod_coeff=(-7498708058499525.D0/42730988524823.D0) 
           IF (nABC.eq.3)  mod_coeff=(388168200.D0/39346519.D0)
           
     ELSE IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(-3494391759411670522125.D0/938918733064795136.D0)
           IF (nABC.eq.2)  mod_coeff=(12673717315968484125.D0/117364841633099392.D0) 
           IF (nABC.eq.3)  mod_coeff=(-13058740833446556675.D0/938918733064795136.D0)         
           IF (nABC.eq.4)  mod_coeff=(141920426025.D0/47725631488.D0)
           
     ELSE IF (nBF.eq.1) THEN
           IF (nABC.eq.1)  mod_coeff=(162661500401561368197795.D0/306660189715788024832.D0)
           IF (nABC.eq.2)  mod_coeff=(-1082898980843340893715.D0/38332523714473503104.D0) 
           IF (nABC.eq.3)  mod_coeff=(1807759484905710896973.D0/306660189715788024832.D0)         
           IF (nABC.eq.4)  mod_coeff=(-1519073565316762422177.D0/613320379431576049664.D0)
           IF (nABC.eq.5)  mod_coeff=(19822620132.D0/12850964153.D0) 

     ELSE IF (nBF.eq.2) THEN
           IF (nABC.eq.1)  mod_coeff=(-484857882180.D0/12850964153.D0)
           IF (nABC.eq.2)  mod_coeff=(1353781553075522550.D0/433676077015382587.D0) 
           IF (nABC.eq.3)  mod_coeff=(-386459389189772640.D0/433676077015382587.D0)         
           IF (nABC.eq.4)  mod_coeff=(230409071761816710.D0/433676077015382587.D0)
           IF (nABC.eq.5)  mod_coeff=(-252196867791369900.D0/433676077015382587.D0)   
           IF (nABC.eq.6)  mod_coeff=(37533510.D0/33746579.D0) 
     
     ELSE IF (nBF.eq.3) THEN
           IF (nABC.eq.1)  mod_coeff=(1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(-3786931.D0/33746579.D0) 
           IF (nABC.eq.3)  mod_coeff=(1317203.D0/33746579.D0)         
           IF (nABC.eq.4)  mod_coeff=(-950419.D0/33746579.D0)
           IF (nABC.eq.5)  mod_coeff=(1317203.D0/33746579.D0)   
           IF (nABC.eq.6)  mod_coeff=(-3786931.D0/33746579.D0)
           IF (nABC.eq.7)  mod_coeff=(1.D0/1.D0)                     
     END IF

 ELSE IF (nFUPO.eq.7)  THEN  !Fup7
     IF (nBF.eq.-4) mod_coeff=(85730400.D0/583.D0)
     
     IF (nBF.eq.-3) THEN
           IF (nABC.eq.1)  mod_coeff=(-5635507762922625.D0/21664692764.D0)
           IF (nABC.eq.2)  mod_coeff=(15444867375.D0/37160708.D0)
           
     ELSE IF (nBF.eq.-2) THEN
           IF (nABC.eq.1)  mod_coeff=(20761075716072534052875.D0/137017730177040596.D0)
           IF (nABC.eq.2)  mod_coeff=(-120220251757048051875.D0/137017730177040596.D0) 
           IF (nABC.eq.3)  mod_coeff=(1724160589200.D0/62681836229.D0)
           
     ELSE IF (nBF.eq.-1) THEN
           IF (nABC.eq.1)  mod_coeff=(-408575713390989123548672329275.D0/8927751494899336549920898.D0)
           IF (nABC.eq.2)  mod_coeff=(5871805636770875672365579875.D0/8927751494899336549920898.D0) 
           IF (nABC.eq.3)  mod_coeff=(-442642720843756315098479025.D0/8927751494899336549920898.D0)         
           IF (nABC.eq.4)  mod_coeff=(855010678162725.D0/142429642014362.D0)
           
     ELSE IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(856878439377961902183533975808.D0/105559194331757479179778763.D0)
           IF (nABC.eq.2)  mod_coeff=(-24560642609136831424008225024.D0/105559194331757479179778763.D0) 
           IF (nABC.eq.3)  mod_coeff=(3156456708204211965679596288.D0/105559194331757479179778763.D0)         
           IF (nABC.eq.4)  mod_coeff=(-3946552160145688289915115264.D0/527795971658787395898893815.D0)
           IF (nABC.eq.5)  mod_coeff=(18040288702464.D0/7411322028115.D0) 

     ELSE IF (nBF.eq.1) THEN
           IF (nABC.eq.1)  mod_coeff=(-14795435087814995636684114313.D0/17512478592908937634021400.D0)
           IF (nABC.eq.2)  mod_coeff=(28728904990534053166700433.D0/700499143716357505360856.D0) 
           IF (nABC.eq.3)  mod_coeff=(-6661037902629054903255171.D0/875623929645446881701070.D0)         
           IF (nABC.eq.4)  mod_coeff=(12470727222059125909850919.D0/4378119648227234408505350.D0)
           IF (nABC.eq.5)  mod_coeff=(-30603525239655102798696213.D0/17512478592908937634021400.D0)   
           IF (nABC.eq.6)  mod_coeff=(17001825574419.D0/11814679301800.D0) 
     
     ELSE IF (nBF.eq.2) THEN
           IF (nABC.eq.1)  mod_coeff=(550045243882331.D0/11814679301800.D0)
           IF (nABC.eq.2)  mod_coeff=(-97691508559029088569.D0/29112921303321112376.D0) 
           IF (nABC.eq.3)  mod_coeff=(14670700849043281223.D0/18195575814575695235.D0)         
           IF (nABC.eq.4)  mod_coeff=(-35432950558980078157.D0/90977879072878476175.D0)
           IF (nABC.eq.5)  mod_coeff=(239309846173560521433.D0/727823032583027809400.D0)   
           IF (nABC.eq.6)  mod_coeff=(-339441006147943684777.D0/727823032583027809400.D0)
           IF (nABC.eq.7)  mod_coeff=(67493158.D0/61603283.D0)  

     ELSE IF (nBF.eq.3) THEN
           IF (nABC.eq.1)  mod_coeff=(-1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(5889875.D0/61603283.D0) 
           IF (nABC.eq.3)  mod_coeff=(-1683987.D0/61603283.D0)         
           IF (nABC.eq.4)  mod_coeff=(950419.D0/61603283.D0)
           IF (nABC.eq.5)  mod_coeff=(-950419.D0/61603283.D0)   
           IF (nABC.eq.6)  mod_coeff=(1683987.D0/61603283.D0)
           IF (nABC.eq.7)  mod_coeff=(-5889875.D0/61603283.D0) 
           IF (nABC.eq.8)  mod_coeff=(1.D0/1.D0)                             
     END IF
     
 ELSE IF (nFUPO.eq.8)  THEN  !Fup8
     IF (nBF.eq.-4) mod_coeff=(2623350240000.D0/1616353.D0)
     
     IF (nBF.eq.-3) THEN
           IF (nABC.eq.1)  mod_coeff=(-10851968380269757356000.D0/3712094238197903.D0)
           IF (nABC.eq.2)  mod_coeff=(4779416218500.D0/2296586351.D0)
           
     ELSE IF (nBF.eq.-2) THEN
           IF (nABC.eq.1)  mod_coeff=(439356645301194949289080392000.D0/247217961565820956904321.D0)
           IF (nABC.eq.2)  mod_coeff=(-1179381477385195579820871000.D0/247217961565820956904321.D0) 
           IF (nABC.eq.3)  mod_coeff=(9370006944480000.D0/107645837683471.D0)
           
     ELSE IF (nBF.eq.-1) THEN
           IF (nABC.eq.1)  mod_coeff=(-34663156558062283342323294762773272500.D0/59714792572572256204219864905559.D0)
           IF (nABC.eq.2)  mod_coeff=(979254560564758102174777831940004375.D0/238859170290289024816879459622236.D0) 
           IF (nABC.eq.3)  mod_coeff=(-11173262177548627382433262985763750.D0/59714792572572256204219864905559.D0)         
           IF (nABC.eq.4)  mod_coeff=(30587129857698631875.D0/2218935496536767716.D0)
           
     ELSE IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(172415068681600402056933703432211632307368500.D0/1462484512896187172572564901988337059463.D0)
           IF (nABC.eq.2)  mod_coeff=(-10434209116967475162894331241606169885957375.D0/5849938051584748690290259607953348237852.D0) 
           IF (nABC.eq.3)  mod_coeff=(2550330081396547384108339053959688875250.D0/17620295336098640633404396409498036861.D0)         
           IF (nABC.eq.4)  mod_coeff=(-133656690199957864776680087696309604487125.D0/5849938051584748690290259607953348237852.D0)
           IF (nABC.eq.5)  mod_coeff=(11532186282762056671200.D0/2636371386511737357247.D0) 

     ELSE IF (nBF.eq.1) THEN
           IF (nABC.eq.1)  mod_coeff=(-4020573133542078193995657122279350927989391200.D0/&
                                                                260962133619814341740108732096374911013949.D0)
           IF (nABC.eq.2)  mod_coeff=(111286338481198853390685109248546074396894250.D0/&
                                                                260962133619814341740108732096374911013949.D0) 
           IF (nABC.eq.3)  mod_coeff=(-163946925649937938842921562743956747958000.D0/3144122091804992069157936531281625433903.D0)         
           IF (nABC.eq.4)  mod_coeff=(3342391597627461087064667601549528462149250.D0/260962133619814341740108732096374911013949.D0)
           IF (nABC.eq.5)  mod_coeff=(-1260214793016996832703867991208112867440800.D0/260962133619814341740108732096374911013949.D0)   
           IF (nABC.eq.6)  mod_coeff=(210026935105261425900.D0/98985345901929707267.D0) 
     
     ELSE IF (nBF.eq.2) THEN
           IF (nABC.eq.1)  mod_coeff=(106314201014932904364535439888436096000.D0/85161588019068842106079202739492853.D0)
           IF (nABC.eq.2)  mod_coeff=(-4724209205923406961731246541178110000.D0/85161588019068842106079202739492853.D0) 
           IF (nABC.eq.3)  mod_coeff=(782554098129663169668397936160520000.D0/85161588019068842106079202739492853.D0)         
           IF (nABC.eq.4)  mod_coeff=(-258438877379494416306944450314290000.D0/85161588019068842106079202739492853.D0)
           IF (nABC.eq.5)  mod_coeff=(140665020059539757019695262186384000.D0/85161588019068842106079202739492853.D0)   
           IF (nABC.eq.6)  mod_coeff=(-113748836318147065741003926584784000.D0/85161588019068842106079202739492853.D0)
           IF (nABC.eq.7)  mod_coeff=(1177619500440000.D0/860345410152359.D0)  

     ELSE IF (nBF.eq.3) THEN
           IF (nABC.eq.1)  mod_coeff=(-14708960882498937600.D0/264126040916774213.D0)
           IF (nABC.eq.2)  mod_coeff=(408801053675335251865870274850.D0/114897480280072546664448890879.D0) 
           IF (nABC.eq.3)  mod_coeff=(-84778897323806807545426766400.D0/114897480280072546664448890879.D0)         
           IF (nABC.eq.4)  mod_coeff=(34360597863839531834483802750.D0/114897480280072546664448890879.D0)
           IF (nABC.eq.5)  mod_coeff=(-23465764846785966736614710400.D0/114897480280072546664448890879.D0)   
           IF (nABC.eq.6)  mod_coeff=(25652393023914281669922936450.D0/114897480280072546664448890879.D0)
           IF (nABC.eq.7)  mod_coeff=(-145590581261108885852059200.D0/374258893420431748092667397.D0) 
           IF (nABC.eq.8)  mod_coeff=(471265114950.D0/435010042483.D0)
           
     ELSE IF (nBF.eq.4) THEN
           IF (nABC.eq.1)  mod_coeff=(1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(-36255072467.D0/435010042483.D0) 
           IF (nABC.eq.3)  mod_coeff=(8802471283.D0/435010042483.D0)         
           IF (nABC.eq.4)  mod_coeff=(-4080029267.D0/435010042483.D0)
           IF (nABC.eq.5)  mod_coeff=(3190676083.D0/435010042483.D0)   
           IF (nABC.eq.6)  mod_coeff=(-4080029267.D0/435010042483.D0)
           IF (nABC.eq.7)  mod_coeff=(8802471283.D0/435010042483.D0) 
           IF (nABC.eq.8)  mod_coeff=(-36255072467.D0/435010042483.D0)
           IF (nABC.eq.9)  mod_coeff=(1.D0/1.D0)                                
     END IF  
     
 ELSE IF (nFUPO.eq.9)  THEN  !Fup9
     IF (nBF.eq.-5) mod_coeff=(2623350240000.D0/132809.D0)
     
     IF (nBF.eq.-4) THEN
           IF (nABC.eq.1)  mod_coeff=(-6833958965375850979768125.D0/189645145642588781.D0)
           IF (nABC.eq.2)  mod_coeff=(16563515744041875.D0/1427954021509.D0)
           
     ELSE IF (nBF.eq.-3) THEN
           IF (nABC.eq.1)  mod_coeff=(8334351835032129531303847647301396875.D0/369537195189614582570471111831.D0)
           IF (nABC.eq.2)  mod_coeff=(-10409458308409939256206836018778125.D0/369537195189614582570471111831.D0) 
           IF (nABC.eq.3)  mod_coeff=(79692465014240400000.D0/258787880858449259.D0)
           
     ELSE IF (nBF.eq.-2) THEN
           IF (nABC.eq.1)  mod_coeff=(-501138543033899946397896408009086042124374709375.D0/&
                                        64631060098821328012917527812024382332507.D0)
           IF (nABC.eq.2)  mod_coeff=(1723657810815402546455840312162658984452968125.D0/&
                                        64631060098821328012917527812024382332507.D0) 
           IF (nABC.eq.3)  mod_coeff=(-194872213442721994418200321546853006758910625.D0/&
                                        258524240395285312051670111248097529330028.D0)         
           IF (nABC.eq.4)  mod_coeff=(35421658056093370639843125.D0/998981248803887567149892.D0)
           
     ELSE IF (nBF.eq.-1) THEN
           IF (nABC.eq.1)  mod_coeff=(6119169082252638727515039775252210392833813475078648510.D0/&
                                       3563305003087134615157984007929744702710544801099.D0)
           IF (nABC.eq.2)  mod_coeff=(-2082134412281568322622210344748437159759376273721030.D0/&
                                       154926304482049331093825391649119334900458469613.D0) 
           IF (nABC.eq.3)  mod_coeff=(4990596908135297219584874920386509477360524263150795.D0/&
                                       7126610006174269230315968015859489405421089602198.D0)         
           IF (nABC.eq.4)  mod_coeff=(-517983331438180520796590378073694184961192576709005.D0/&
                                       7126610006174269230315968015859489405421089602198.D0)
           IF (nABC.eq.5)  mod_coeff=(125763317196573275605401120.D0/14267755305131480665891163.D0) 

     ELSE IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(-1652853788598801277214797641335296216404621190406766947565.D0/&
                                        6379848476784928023447247637312788724169026222438221.D0)
           IF (nABC.eq.2)  mod_coeff=(1102794586827163627175716500004095396555241275266087745.D0/&
                                        277384716381953392323793375535338640181262009671227.D0) 
           IF (nABC.eq.3)  mod_coeff=(-8267969705549955051205742126123193066785624665041588735.D0/&
                                        25519393907139712093788990549251154896676104889752884.D0)         
           IF (nABC.eq.4)  mod_coeff=(1376386802262181912347360430434048458509022913642676665.D0/&
                                        25519393907139712093788990549251154896676104889752884.D0)
           IF (nABC.eq.5)  mod_coeff=(-84809107240004428416670410580714538243209755107200290.D0/&
                                        6379848476784928023447247637312788724169026222438221.D0)   
           IF (nABC.eq.6)  mod_coeff=(1569563704959762835637001450.D0/447151520357962590093378167.D0) 
     
     ELSE IF (nBF.eq.1) THEN
           IF (nABC.eq.1)  mod_coeff=(26748164974157142120595027132490329937639119901985183000.D0/&
                                       1008009645825321924213717410779843170440728623702349.D0)
           IF (nABC.eq.2)  mod_coeff=(-708354363178793766674819117455591827228373472220603000.D0/&
                                       1008009645825321924213717410779843170440728623702349.D0) 
           IF (nABC.eq.3)  mod_coeff=(81191509147024252132317030201220423419588943708141875.D0/&
                                       1008009645825321924213717410779843170440728623702349.D0)         
           IF (nABC.eq.4)  mod_coeff=(-131261698924334221757285851516710791818258814295541875.D0/&
                                       7056067520777253469496021875458902193085100365916443.D0)
           IF (nABC.eq.5)  mod_coeff=(48273887363437794494451108359512783433302495111158750.D0/&
                                       7056067520777253469496021875458902193085100365916443.D0)   
           IF (nABC.eq.6)  mod_coeff=(-24440320488386655656737931284546510962245126689895250.D0/&
                                        7056067520777253469496021875458902193085100365916443.D0)
           IF (nABC.eq.7)  mod_coeff=(30289515845990490423702000.D0/15780036966280670510248829.D0)  

     ELSE IF (nBF.eq.2) THEN
           IF (nABC.eq.1)  mod_coeff=(-6037530802505329474798388306561885656025016475200.D0/&
                                       3456062386475839249182513847591296528409889603.D0)
           IF (nABC.eq.2)  mod_coeff=(246976364534549121106465441530402334983377764800.D0/&
                                       3456062386475839249182513847591296528409889603.D0) 
           IF (nABC.eq.3)  mod_coeff=(-36838789990153177573351525067151067783974394350.D0/&
                                       3456062386475839249182513847591296528409889603.D0)         
           IF (nABC.eq.4)  mod_coeff=(75592162400572816143089272118722861858681224750.D0/&
                                       24192436705330874744277596933139075698869227221.D0)
           IF (nABC.eq.5)  mod_coeff=(-36164133034456581328351979489959032804075690000.D0/&
                                       24192436705330874744277596933139075698869227221.D0)   
           IF (nABC.eq.6)  mod_coeff=(25883664150939280357369989874986235872921963600.D0/&
                                       24192436705330874744277596933139075698869227221.D0)
           IF (nABC.eq.7)  mod_coeff=(-26001615562951658133054794978071301339232471150.D0/&
                                       24192436705330874744277596933139075698869227221.D0) 
           IF (nABC.eq.8)  mod_coeff=(2020564213013322729450.D0/1533103931063413307449.D0)
           
     ELSE IF (nBF.eq.3) THEN
           IF (nABC.eq.1)  mod_coeff=(99785066748225155994098.D0/1533103931063413307449.D0)
           IF (nABC.eq.2)  mod_coeff=(-4640758230320684167797372903686528.D0/1242037251008700783536245585695003.D0) 
           IF (nABC.eq.3)  mod_coeff=(846554828670884948306967216870488.D0/1242037251008700783536245585695003.D0)         
           IF (nABC.eq.4)  mod_coeff=(-98454551669577810982721057827082.D0/414012417002900261178748528565001.D0)
           IF (nABC.eq.5)  mod_coeff=(169023189930556211489112879013270.D0/1242037251008700783536245585695003.D0)   
           IF (nABC.eq.6)  mod_coeff=(-149358635983564376440199698744864.D0/1242037251008700783536245585695003.D0)
           IF (nABC.eq.7)  mod_coeff=(66835501520586764215214962430984.D0/414012417002900261178748528565001.D0) 
           IF (nABC.eq.8)  mod_coeff=(-414285380805601579811710647330782.D0/1242037251008700783536245585695003.D0)
           IF (nABC.eq.9)  mod_coeff=(870020084966.D0/810145500147.D0) 
           
     ELSE IF (nBF.eq.4) THEN
           IF (nABC.eq.1)  mod_coeff=(-1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(59874584819.D0/810145500147.D0) 
           IF (nABC.eq.3)  mod_coeff=(-12635560115.D0/810145500147.D0)        
           IF (nABC.eq.4)  mod_coeff=(1656460817.D0/270048500049.D0)
           IF (nABC.eq.5)  mod_coeff=(-3190676083.D0/810145500147.D0)  
           IF (nABC.eq.6)  mod_coeff=(3190676083.D0/810145500147.D0)
           IF (nABC.eq.7)  mod_coeff=(-1656460817.D0/270048500049.D0) 
           IF (nABC.eq.8)  mod_coeff=(12635560115.D0/810145500147.D0)
           IF (nABC.eq.9)  mod_coeff=(-59874584819.D0/810145500147.D0) 
           IF (nABC.eq.10)  mod_coeff=(1.D0/1.D0)                               
     END IF 
     
 ELSE IF (nFUPO.eq.10) THEN  !Fup10
     IF (nBF.eq.-5) mod_coeff=(35424672300864000.D0/134926369.D0)
     
     IF (nBF.eq.-4) THEN
           IF (nABC.eq.1)  mod_coeff=(-12035766223943907902076129394500.D0/24891079403762567473777.D0)
           IF (nABC.eq.2)  mod_coeff=(13126995824791983750.D0/184478983524433.D0)
           
     ELSE IF (nBF.eq.-3) THEN
           IF (nABC.eq.1)  mod_coeff=(2160947740319145346258565263672557949462854375.D0/6992747124779609400204193934107812247.D0)
           IF (nABC.eq.2)  mod_coeff=(-2518050545574140883946681070318460832093125.D0/13985494249559218800408387868215624494.D0) 
           IF (nABC.eq.3)  mod_coeff=(45621215072742810944520000.D0/37905386246089474457959.D0)
           
     ELSE IF (nBF.eq.-2) THEN
           IF (nABC.eq.1)  mod_coeff=(-616533727729706056570915469921787733029435209564870148253125.D0/&
                                        5602888234384282661572023787721899880429818646609792.D0)
           IF (nABC.eq.2)  mod_coeff=(1024041611393032673692866837360362537197818872640215600625.D0/&
                                        5602888234384282661572023787721899880429818646609792.D0) 
           IF (nABC.eq.3)  mod_coeff=(-18201454131139987406342374858685349530908026186310760625.D0/&
                                        5602888234384282661572023787721899880429818646609792.D0)         
           IF (nABC.eq.4)  mod_coeff=(29842043863429688851935305533125.D0/295624911879762578383262853376.D0)
           
     ELSE IF (nBF.eq.-1) THEN
           IF (nABC.eq.1)  mod_coeff=(529324814283908549851255650556486544324500904449974968321212244249819625.D0/&
                                       20511938799616678708284481651925723367146881165735905556119852416.D0)
           IF (nABC.eq.2)  mod_coeff=(-2101679467237125359997408668011429331975870252149269381153341018595525.D0/&
                                       20511938799616678708284481651925723367146881165735905556119852416.D0) 
           IF (nABC.eq.3)  mod_coeff=(71088649862883936002999043506714796198169949027694226129824358352325.D0/&
                                       20511938799616678708284481651925723367146881165735905556119852416.D0)         
           IF (nABC.eq.4)  mod_coeff=(-9990259653342452470110097509542783652180361509326753364279128339775.D0/&
                                       41023877599233357416568963303851446734293762331471811112239704832.D0)
           IF (nABC.eq.5)  mod_coeff=(2730600568949506468464176538457492800.D0/138770029015412300243025321454118707.D0) 

     ELSE IF (nBF.eq.0) THEN
           IF (nABC.eq.1)  mod_coeff=(-408306279238400873889137686131890638337927828969505230235698525378858334318375.D0/&
                                       95548942863793453661090704634701493080699084104200588993967072809613302.D0)
           IF (nABC.eq.2)  mod_coeff=(3378427324295507055273412128012617523315460373652036466993632647955626815875.D0/&
                                       95548942863793453661090704634701493080699084104200588993967072809613302.D0) 
           IF (nABC.eq.3)  mod_coeff=(-184774072881852448128813829841733850708690135595972044079492837859879766875.D0/&
                                       95548942863793453661090704634701493080699084104200588993967072809613302.D0)         
           IF (nABC.eq.4)  mod_coeff=(42717427883816895754011776640327642493118517327850021783100294669234837625.D0/&
                                       191097885727586907322181409269402986161398168208401177987934145619226604.D0)
           IF (nABC.eq.5)  mod_coeff=(-1797091258303472004592421857951746215015399171183050667199524536270606500.D0/&
                                       47774471431896726830545352317350746540349542052100294496983536404806651.D0)   
           IF (nABC.eq.6)  mod_coeff=(2215867687961194197121448144799623250.D0/344270818208092480944932585630496793.D0) 
     
     ELSE IF (nBF.eq.1) THEN
           IF (nABC.eq.1)  mod_coeff=(3685180771564417158219644664234532587785970324189458527668141717545405219385375.D0/&
                                       7246462098393241081717865028267021112160484152651664247816015655574551854.D0)
           IF (nABC.eq.2)  mod_coeff=(-56269060393783446245157067778818768252311557572798159957490234398865253562875.D0/&
                                       7246462098393241081717865028267021112160484152651664247816015655574551854.D0) 
           IF (nABC.eq.3)  mod_coeff=(4475962508352073335909178898062321840300805413265875966886007811608583665075.D0/&
                                       7246462098393241081717865028267021112160484152651664247816015655574551854.D0)         
           IF (nABC.eq.4)  mod_coeff=(-1473172987833958465555609930696875395453059534661941585433832352740945719025.D0/&
                                       14492924196786482163435730056534042224320968305303328495632031311149103708.D0)
           IF (nABC.eq.5)  mod_coeff=(7295370088918590015342682081336126231624390161129678471515022624634167900.D0/&
                                       278710080707432349296840962625654658160018621255833240300615986752867379.D0)   
           IF (nABC.eq.6)  mod_coeff=(-32020361189166118224101133733254687959309003006599920604718663270548043250.D0/&
                                       3623231049196620540858932514133510556080242076325832123908007827787275927.D0)
           IF (nABC.eq.7)  mod_coeff=(31410483716130686451504865245518042400.D0/10524362965340209988510616850919957039.D0)  

     ELSE IF (nBF.eq.2) THEN
           IF (nABC.eq.1)  mod_coeff=(-46639739198413347741833057907112725206689682420174264466916142984438566500.D0/&
                                       1096310260260929735354697535491349804158700840243404017494676290470617.D0)
           IF (nABC.eq.2)  mod_coeff=(1177554359831484194981845661041205910476756513833258748597423585713790700.D0/&
                                       1096310260260929735354697535491349804158700840243404017494676290470617.D0) 
           IF (nABC.eq.3)  mod_coeff=(-126034420098636561457277154245308815774979560318328296669825510054953700.D0/&
                                       1096310260260929735354697535491349804158700840243404017494676290470617.D0)         
           IF (nABC.eq.4)  mod_coeff=(27033853041377011190930371726763456814894317387900371640033270071673625.D0/&
                                       1096310260260929735354697535491349804158700840243404017494676290470617.D0)
           IF (nABC.eq.5)  mod_coeff=(-715280131074516491140189165815023757478138705308847269892107618974250.D0/&
                                       84331558481609979642669041191642292627592372326415693653436637728509.D0)   
           IF (nABC.eq.6)  mod_coeff=(4574686286518112714264428955578501887761854709610340036032073175264250.D0/&
                                       1096310260260929735354697535491349804158700840243404017494676290470617.D0)
           IF (nABC.eq.7)  mod_coeff=(-2912286493486308383493224510765481870915046776310359925699333887097050.D0/&
                                       1096310260260929735354697535491349804158700840243404017494676290470617.D0) 
           IF (nABC.eq.8)  mod_coeff=(185240670444396320069522734968825.D0/104168799942704225150507756720503.D0)
           
     ELSE IF (nBF.eq.3) THEN
           IF (nABC.eq.1)  mod_coeff=(39537455095088698519966987861113746065801926702089510335658340.D0/&
                                      16854614311793388287480171755745248743067278781646847754369.D0)
           IF (nABC.eq.2)  mod_coeff=(-1497351534900229702820918215575362867936597254621873667700288.D0/&
                                      16854614311793388287480171755745248743067278781646847754369.D0) 
           IF (nABC.eq.3)  mod_coeff=(202818593367259882482310362318105749779634540957245801366176.D0/&
                                      16854614311793388287480171755745248743067278781646847754369.D0)         
           IF (nABC.eq.4)  mod_coeff=(-53272804804711751695232590396927259540630767199484782021343.D0/&
                                      16854614311793388287480171755745248743067278781646847754369.D0)
           IF (nABC.eq.5)  mod_coeff=(22560754061725012357042879908853018620602823211143793470030.D0/&
                                      16854614311793388287480171755745248743067278781646847754369.D0)   
           IF (nABC.eq.6)  mod_coeff=(-14167010847765985410574278233744407411720200562000431157230.D0/&
                                      16854614311793388287480171755745248743067278781646847754369.D0)
           IF (nABC.eq.7)  mod_coeff=(12578975878836615216391217050987077044143711405215361743402.D0/&
                                      16854614311793388287480171755745248743067278781646847754369.D0) 
           IF (nABC.eq.8)  mod_coeff=(-15104849341218548494607844335757748465926240129439664079999.D0/&
                                      16854614311793388287480171755745248743067278781646847754369.D0)
           IF (nABC.eq.9)  mod_coeff=(207024222435079079384683164.D0/161800983798065265469127623.D0) 
           
     ELSE IF (nBF.eq.4) THEN
          IF (nABC.eq.1)  mod_coeff=(-12089412128466841112165154780.D0/161800983798065265469127623.D0)
          IF (nABC.eq.2)  mod_coeff=(32334619565700420126725658795502747906712502.D0/8299209459049251635752457582599987485209147.D0) 
          IF (nABC.eq.3)  mod_coeff=(-5265255467128787989086844081252889071903296.D0/8299209459049251635752457582599987485209147.D0)         
          IF (nABC.eq.4)  mod_coeff=(1612332148193379907757079950669592191098086.D0/8299209459049251635752457582599987485209147.D0)
          IF (nABC.eq.5)  mod_coeff=(-793390382679114524990860300482588078555852.D0/8299209459049251635752457582599987485209147.D0)   
          IF (nABC.eq.6)  mod_coeff=(587085205319329891631610270578670873992790.D0/8299209459049251635752457582599987485209147.D0)
          IF (nABC.eq.7)  mod_coeff=(-636837902017146572839419174916106932689888.D0/8299209459049251635752457582599987485209147.D0) 
          IF (nABC.eq.8)  mod_coeff=(1013712543537296217290710040578283241590214.D0/8299209459049251635752457582599987485209147.D0)
          IF (nABC.eq.9)  mod_coeff=(-2422512783064281409433038714968240927953004.D0/8299209459049251635752457582599987485209147.D0) 
          IF (nABC.eq.10)  mod_coeff=(54699403878925146.D0/51292700849130989.D0) 

     ELSE IF (nBF.eq.5) THEN
           IF (nABC.eq.1)  mod_coeff=(1.D0/1.D0)
           IF (nABC.eq.2)  mod_coeff=(-3406703029794157.D0/51292700849130989.D0) 
           IF (nABC.eq.3)  mod_coeff=(635909188015085.D0/51292700849130989.D0)         
           IF (nABC.eq.4)  mod_coeff=(-217218559829485.D0/51292700849130989.D0)
           IF (nABC.eq.5)  mod_coeff=(118304204497133.D0/51292700849130989.D0)   
           IF (nABC.eq.6)  mod_coeff=(-97123863274861.D0/51292700849130989.D0)
           IF (nABC.eq.7)  mod_coeff=(118304204497133.D0/51292700849130989.D0)
           IF (nABC.eq.8)  mod_coeff=(-217218559829485.D0/51292700849130989.D0)
           IF (nABC.eq.9)  mod_coeff=(635909188015085.D0/51292700849130989.D0) 
           IF (nABC.eq.10)  mod_coeff=(-3406703029794157.D0/51292700849130989.D0) 
           IF (nABC.eq.11)  mod_coeff=(1.D0/1.D0)                                 
     END IF                                                                 
 END IF
end function 

END MODULE Global_Data

MODULE Assembler
    use FUP_0_16_D
	use SPLINE_1_4_D
	use BASIS_STR
	use Geometry
	use Global_Data
	
	!
	!Subroutine Diffusion_Linear
	!Subroutine Diffusion_Non_Linear
	!Subroutine Advection_Linear
	!Subroutine Boundary_Conditions
	!Subroutine Initial_Conditions
	!Subroutine Assembling_Problem
	!...
     Implicit none
	
	 PRIVATE 
		Integer(kind=4) :: iiAssem
		
	 PUBLIC Diffusion_Linear
	 
	 Contains
	 
	 Subroutine Diffusion_Linear
	  !Integer(kind=4) :: 
	   If(DimenSpat.eq.1) then
	    Select case(Formulation)
	     Case("control_volume")
	      write(*,*) "Work in progress ",Formulation, DimenSpat
	      read(*,*)
	     Case("collocation")
	      write(*,*) "Work in progress ",Formulation, DimenSpat
	      read(*,*)
	     Case("galerkin")
	      write(*,*) "Work in progress ",Formulation, DimenSpat
	      read(*,*)
	    End select
	   Else if(DimenSpat.eq.2) then
	    Select case(Formulation)
	     Case("control_volume")
	      
	     Case("collocation")
	      write(*,*) "Work in progress ",Formulation, DimenSpat
	      read(*,*)
	     Case("galerkin")
	      write(*,*) "Work in progress ",Formulation, DimenSpat
	      read(*,*)
	    End select
	   Else !3-D
	    Select case(Formulation)
	     Case("control_volume")
	      write(*,*) "Work in progress ",Formulation, DimenSpat
	      read(*,*)
	     Case("collocation")
	      write(*,*) "Work in progress ",Formulation, DimenSpat
	      read(*,*)
	     Case("galerkin")
	      write(*,*) "Work in progress ",Formulation, DimenSpat
	      read(*,*)
	    End select
	   
	   End if !DimenSpat

	 End subroutine Diffusion_Linear
	 
END MODULE Assembler

MODULE Control_Data
	implicit none
	!Control data parameters...
	
END MODULE Control_Data

MODULE Solver
!PETSc and HYPRE are external libraries
!BANDSol
!Newton subroutine for non-linear systems

	Implicit none
	
	PRIVATE 
		Integer(kind=4) iiSolve
!~ 	PUBLIC 
	
	CONTAINS
!~  subroutine pardiso_sym_f90(n,nnz,ia,ja,a,b)
!~   !Sparse matrix solver. MKL libraries.
!~           USE mkl_pardiso
!~           IMPLICIT NONE
!~           INTEGER (kind=4), PARAMETER :: dp = KIND(1.0D0)
!~           !.. Internal solver memory pointer 
!~           TYPE(MKL_PARDISO_HANDLE), ALLOCATABLE  :: pt(:)
!~           !.. All other variables
!~           INTEGER (kind=4) maxfct, mnum, mtype, phase, n, nrhs, error, &
!~                            msglvl, nnz
!~           INTEGER (kind=4) error1
!~           INTEGER (kind=4), ALLOCATABLE :: iparm( : )
!~           !INTEGER, ALLOCATABLE :: ia( : )
!~           !INTEGER, ALLOCATABLE :: ja( : )
!~           !REAL(KIND=DP), ALLOCATABLE :: a( : )
!~           !REAL(KIND=DP), ALLOCATABLE :: b( : )
!~           REAL(KIND=DP), ALLOCATABLE :: x( : )
!~           INTEGER (kind=4) i, idum(1)
!~           REAL(KIND=DP) ddum(1)
!~           !
!~           integer (kind=4) ia(n+1),ja(nnz)
!~           REAL(KIND=DP) a(nnz),b(n)!,x(n)
!~           !
!~           !.. Fill all arrays containing matrix data.
!~           !n = 8 
!~           !nnz = 18
!~           nrhs = 1 
!~           maxfct = 1 
!~           mnum = 1      
!~   !EXAMPLE IS FOR SYMMETRIC MATRIX
!~           !ALLOCATE( ia ( n + 1 ) )
!~           !ia = (/ 1, 5, 8, 10, 12, 15, 17, 18, 19 /)
!~           !ALLOCATE( ja ( nnz ) )
!~           !ja = (/ 1,    3,       6, 7,    &
!~           !           2, 3,    5,          &
!~           !              3,             8, &
!~           !                 4,       7,    &
!~           !                    5, 6, 7,    &
!~           !                       6,    8, &
!~           !                          7,    &
!~           !                             8 /)
!~           !ALLOCATE( a ( nnz ) )
!~           !a = (/ 7.d0,        1.d0,             2.d0, 7.d0,        &
!~           !             -4.d0, 8.d0,       2.d0,                    &
!~           !                    1.d0,                         5.d0,  &
!~           !                          7.d0,             9.d0,        &
!~           !                                5.d0, 1.d0, 5.d0,        &
!~           !                                     -1.d0,       5.d0,  &
!~           !                                           11.d0,        &
!~           !                                                  5.d0 /)
!~           !ALLOCATE( b ( n ) )
!~           ALLOCATE( x ( n ) )
!~           !..
!~           !.. Set up PARDISO control parameter
!~           !..
!~           ALLOCATE( iparm ( 64 ) )
!~           do i = 1, 64
!~              iparm(i) = 0
!~           end do 
!~           iparm(1) = 1 ! no solver default
!~           iparm(2) = 2 ! fill-in reordering from METIS
!~           iparm(4) = 0 ! no iterative-direct algorithm
!~           iparm(5) = 0 ! no user fill-in reducing permutation
!~           iparm(6) = 0 ! =0 solution on the first n compoments of x
!~           iparm(8) = 9 ! numbers of iterative refinement steps
!~           iparm(10) = 13 ! perturbe the pivot elements with 1E-13
!~           iparm(11) = 1 ! use nonsymmetric permutation and scaling MPS
!~           iparm(13) = 0 ! maximum weighted matching algorithm is switched-off (default for symmetric). 
!~                         !Try iparm(13) = 1 in case of inappropriate accuracy
!~           iparm(14) = 0 ! Output: number of perturbed pivots
!~           iparm(18) = -1 ! Output: number of nonzeros in the factor LU
!~           iparm(19) = -1 ! Output: Mflops for LU factorization
!~           iparm(20) = 0 ! Output: Numbers of CG Iterations
!~           error  = 0 ! initialize error flag
!~           msglvl = 0 ! print statistical information
!~           mtype  = 11 ! real and nonsymmetric (mtype=11)
!~                       ! symmetric, indefinite (mtype=-2)    
!~           !.. Initiliaze the internal solver memory pointer. This is only
!~           ! necessary for the FIRST call of the PARDISO solver.
!~           ALLOCATE ( pt ( 64 ) )
!~           do i = 1, 64
!~              pt( i )%DUMMY =  0 
!~           end do
!~           !.. Reordering and Symbolic Factorization, This step also allocates
!~           ! all memory that is necessary for the factorization
!~           phase = 11 ! only reordering and symbolic factorization
!~           CALL pardiso (pt, maxfct, mnum, mtype, phase, n, a, ia, ja, &
!~                  idum, nrhs, iparm, msglvl, ddum, ddum, error) 
!~           !WRITE(*,*) 'Reordering completed ... '
!~           IF (error /= 0) THEN
!~              !WRITE(*,*) 'The following ERROR was detected: ', error
!~              GOTO 1000
!~           END IF
!~           !WRITE(*,*) 'Number of nonzeros in factors = ',iparm(18)
!~           !WRITE(*,*) 'Number of factorization MFLOPS = ',iparm(19)
!~           !.. Factorization.
!~           phase = 22 ! only factorization
!~           CALL pardiso (pt, maxfct, mnum, mtype, phase, n, a, ia, ja, &
!~                        idum, nrhs, iparm, msglvl, ddum, ddum, error)
!~           !WRITE(*,*) 'Factorization completed ... '
!~           IF (error /= 0) THEN
!~              WRITE(*,*) 'The following ERROR was detected: ', error
!~              GOTO 1000
!~           ENDIF
!~           !.. Back substitution and iterative refinement
!~           iparm(8) = 2 ! max numbers of iterative refinement steps
!~           phase = 33 ! only factorization
!~           !do i = 1, n
!~           !   b(i) = 1.d0
!~           !end do
!~           CALL pardiso (pt, maxfct, mnum, mtype, phase, n, a, ia, ja, &
!~                    idum, nrhs, iparm, msglvl, b, x, error)
!~           !WRITE(*,*) 'Solve completed ... '
!~           IF (error /= 0) THEN
!~              WRITE(*,*) 'The following ERROR was detected: ', error
!~              GOTO 1000
!~           ENDIF
!~           !WRITE(*,*) 'The solution of the system is '
!~           !DO i = 1, n
!~           !   WRITE(*,*) ' x(',i,') = ', x(i)
!~           !END DO
!~           !!!
!~           b=x
!~   1000     CONTINUE
!~           !.. Termination and release of memory
!~           phase = -1 ! release internal memory
!~           CALL pardiso (pt, maxfct, mnum, mtype, phase, n, ddum, idum,   &
!~             idum,idum, nrhs, iparm, msglvl, ddum, ddum, error1)
!~           !IF ( ALLOCATED( ia ) )      DEALLOCATE( ia )
!~           !IF ( ALLOCATED( ja ) )      DEALLOCATE( ja )
!~           !IF ( ALLOCATED( a ) )       DEALLOCATE( a )
!~           !IF ( ALLOCATED( b ) )       DEALLOCATE( b )
!~           !IF ( ALLOCATED( x ) )       DEALLOCATE( x )
!~           IF ( ALLOCATED( iparm ) )   DEALLOCATE( iparm )
!~           IF (error1 /= 0) THEN
!~              WRITE(*,*) 'The following ERROR on release stage was,  &
!~                          detected: ', error1
!~              STOP 1
!~           ENDIF
!~           IF ( error /= 0 ) then
!~               write(*,*) 'error'  !***!
!~               read(*,*)
!~               STOP 1
!~           endif
!~   !STOP 0
!~    END SUBROUTINE
 
 subroutine Simq(A,B,N,KS)
        !Solves system of equations in form Ax=b.
        !
        ! Input:
        !        A - "left side" matrix dimension (n x n)
        !        B - "right side" vector dimension (n)
        !        N - defines dimension "n" 
        !        KS - if KS=1 - SIMQ singularity, else if KS=0 system is OK 
        ! Output:
        !        B - vector system solutions
        !
        IMPLICIT REAL (kind=8) (A-H, O-Z)
        DIMENSION A(1),B(1)
        !
        integer (kind=4) jj,n,ks,j,jy,it,i,ij,imax,i1,k,i2,iqs,&
                         ix,ixj,jx,ixjx,jjx,ny,ia,ib,ic
              
    !C
    !C***  FORWARD RJESENJE
    !C
          TOL = 0.000000001D0
          KS = 0
          JJ = -N
          DO 65 J=1,N
          JY=J+1
          JJ=JJ+N+1
          BIGA = 0.0D0
          IT=JJ-J
          DO 30 I=J,N
    !C
    !C***  TRAZANJE MAKSIMALNOG KOEFICIJENTA U STUPCU
    !C
          IJ=IT+I
          IF(ABS(BIGA)-ABS(A(IJ)))  20,30,30
      20  BIGA = A(IJ)
          IMAX=I
      30  CONTINUE
    !C
    !C***  ISPITIVANJE DA LI JE PIVOT MANJI OD TOLERANCE (SINGULARNA MATRICA)
    !C
          IF(ABS(BIGA)-TOL) 35,35,40
      35  KS=1
          RETURN
    !C
    !C***  MEDJUSOBNA ZAMJENA REDAKA AKO JE POTREBNO
    !C
      40  I1=J+N*(J-2)
          IT=IMAX-J
          DO 50 K=J,N
          I1=I1+N
          I2=I1+IT
          SAVE = A(I1)
          A(I1) = A(I2)
          A(I2) = SAVE
    !C
    !C***  DIJELJENJE JEDNADZBE S VODECIM KOEFICIJENTOM
    !C
      50  A(I1) = A(I1)/BIGA
          SAVE = B(IMAX)
          B(IMAX) = B(J)
          B(J) = SAVE/BIGA
    !C
    !C***  ELIMINIRANJE SLIJEDECE VARIJABLE
    !C
          IF(J-N) 55,70,55
      55  IQS=N*(J-1)
          DO 65 IX=JY,N
          IXJ=IQS+IX
          IT=J-IX
          DO 60 JX=JY,N
          IXJX = N*(JX-1)+IX
          JJX=IXJX+IT
      60  A(IXJX) = A(IXJX)-(A(IXJ)*A(JJX))
      65  B(IX) = B(IX)-(B(J)*A(IXJ))
    !C
    !C***  BACK SUPSTITUCIJA
    !C
      70  NY=N-1
          IT=N*N
          DO 80 J=1,NY
          IA=IT-J
          IB=N-J
          IC=N
          DO 80 K=1,J
          B(IB)=B(IB)-A(IA)*B(IC)
          IA=IA-N
      80  IC=IC-1
          RETURN
  
    end subroutine Simq  
 
!~  subroutine Solve_Problem
!~ 	!use matrix and RHS from assembling module for linear problems
!~ 	!use residual function from assembling module for non-linear problems
!~  end subroutine Solve_Problem
 
END MODULE Solver

MODULE Output
	!Write results, Convergence test, etc.
	!Subroutine Output_Data 
	!End Subroutine Output_Data
	
END MODULE Output

MODULE Auxiliary_variables
	!e.g. -Material * der var (e.g.-k * dh/dn)
	
!~ 	subroutine Diffusion_Linear_Flux
	
!~ 	end subroutine Diffusion_Linear_Flux
	
END MODULE Auxiliary_variables

PROGRAM HierarFup
use FUP_0_16_D
use SPLINE_1_4_D
use Global_Data
use Geometry
Implicit none

Real (kind=8)  CpuTimeEnd, CpuTimeStart
call racun



	print*, "Print this..."

	print*, fupn(1,0.25D0,0.25D0,0.25D0,0)
	call CPU_TIME(CpuTimeStart)
    
	!Read all global data for all variables
	call Input_Global_Data

!~ 	!Read all control and specific problem data (e.g., Manning coeff, Van Genuchten parameters,...)
!~ 	call Input_Problem_Type_Data

!~ 	!End of preprocessing procedure

!~ 	call Convergence 
	
	call CPU_TIME(CpuTimeEnd)
	write(*,*)
	write(*,*) "CPU time (preprocessing)",CpuTimeEnd-CpuTimeStart
	write(*,*) " "
	
End PROGRAM HierarFup
